package com.digiwin.athena.agiledataecho.service.aiBoard;


import com.digiwin.athena.agiledataecho.dto.aiBoard.AIBoardQueryReq;
import com.digiwin.athena.agiledataecho.dto.aiBoard.EchoAIBoardDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.show.component.gridster.GridGroupDTO;

import java.util.List;

public interface EchoAiBoardService {

    /**
     * 保存分析师数据
     * @param user
     * @return
     */
    Boolean saveAgileDataAIBoard(AuthoredUser user, EchoAIBoardDTO echoAIBoardDTO);

    /**
     * 更新分析师数据
     * @param echoAIBoardDTO
     * @return
     */
    Boolean updateAgileDataAIBoard(AuthoredUser user, EchoAIBoardDTO echoAIBoardDTO);

    /**
     * 删除分析师数据
     * @param aiBoardQueryReq
     * @return
     */
    Boolean deleteAgileDataAIBoard(AuthoredUser user,AIBoardQueryReq aiBoardQueryReq);

    /**
     * 查询分析师数据
     * @param aiBoardQueryReq
     * @return
     */
    EchoAIBoardDTO queryAgileDataAIBoard(AuthoredUser user,AIBoardQueryReq aiBoardQueryReq);

    /**
     * 获取预览布局
     * @param user
     * @param aiBoardQueryReq
     * @return
     */
    List<GridGroupDTO> getPreviewLayout(AuthoredUser user,AIBoardQueryReq aiBoardQueryReq,String locale);


}
