package com.digiwin.athena.agiledataecho.service.autoData.impl;

import com.digiwin.athena.agiledataecho.dto.autoData.EchoAutoDataDTO;
import com.digiwin.athena.agiledataecho.service.autoData.EchoAutoDataService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import java.time.LocalTime;

@Service
public class EchoAutoDataServiceImpl implements EchoAutoDataService {

    @Autowired
    @Qualifier("mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;

    private static final String MONGODB_COLLECTION_NAME = "agile_data_autoData_report";

    /**
     * 新增分析师报告信息
     * @param echoAutoDataDTO
     * @return
     */
    @Override
    public Boolean saveAgileDataAutoData(AuthoredUser user,EchoAutoDataDTO echoAutoDataDTO) {
        if(echoAutoDataDTO == null){
            return false;
        }
        if(echoAutoDataDTO.getMessageId() == null){
            return false;
        }
        echoAutoDataDTO.setUserId(user.getUserId());
        echoAutoDataDTO.setUserName(user.getUserName());
        echoAutoDataDTO.setTenantId(user.getTenantId());
        echoAutoDataDTO.setCreateTime(LocalTime.now());
        mongoAgileDataPageViewTemplate.insert(echoAutoDataDTO, MONGODB_COLLECTION_NAME);
        return true;
    }

    /**
     * 修改分析师报告信息
     * @param echoAutoDataDTO
     * @return
     */
    @Override
    public Boolean updateAgileDataAutoData(AuthoredUser user,EchoAutoDataDTO echoAutoDataDTO) {
        if(echoAutoDataDTO == null){
            return false;
        }
        Query query = Query.query(Criteria.where("userId").is(user.getUserId())
                .and("tenantId").is(user.getTenantId())
                .and("messageId").is(echoAutoDataDTO.getMessageId()));
        Update update = new Update();
        if(StringUtils.isNotEmpty(echoAutoDataDTO.getStatus())) {
            update.set("status", echoAutoDataDTO.getStatus());
        }
        if(StringUtils.isNotEmpty(echoAutoDataDTO.getPdfUrl())) {
            update.set("pdfUrl", echoAutoDataDTO.getPdfUrl());
        }
        if(StringUtils.isNotEmpty(echoAutoDataDTO.getWordUrl())) {
            update.set("wordUrl", echoAutoDataDTO.getWordUrl());
        }
        if(StringUtils.isNotEmpty(echoAutoDataDTO.getLimitDay())) {
            update.set("limitDay", echoAutoDataDTO.getLimitDay());
        }
        if(StringUtils.isNotEmpty(echoAutoDataDTO.getPdfCreateDate())) {
            update.set("pdfCreateDate", echoAutoDataDTO.getPdfCreateDate());
        }
        if(StringUtils.isNotEmpty(echoAutoDataDTO.getWordCreateDate())) {
            update.set("wordCreateDate", echoAutoDataDTO.getWordCreateDate());
        }
        if(StringUtils.isNotEmpty(echoAutoDataDTO.getPdfExpireDate())) {
            update.set("pdfExpireDate", echoAutoDataDTO.getPdfExpireDate());
        }
        if(StringUtils.isNotEmpty(echoAutoDataDTO.getWordExpireDate())) {
            update.set("wordExpireDate", echoAutoDataDTO.getWordExpireDate());
        }
        if(StringUtils.isNotEmpty(echoAutoDataDTO.getShowDmcId())) {
            update.set("showDmcId", echoAutoDataDTO.getShowDmcId());
        }
        update.set("updateTime", LocalTime.now());
        mongoAgileDataPageViewTemplate.updateFirst(query,update,MONGODB_COLLECTION_NAME);
        return true;
    }

    /**
     * 删除分析师数据
     * @param user
     * @param echoAutoDataDTO
     * @return
     */
    @Override
    public Boolean deleteAgileDataAutoData(AuthoredUser user,EchoAutoDataDTO echoAutoDataDTO) {
        if(echoAutoDataDTO == null){
            return false;
        }
        Query query = Query.query(Criteria.where("userId").is(user.getUserId())
                .and("tenantId").is(user.getTenantId())
                .and("messageId").is(echoAutoDataDTO.getMessageId()));
        mongoAgileDataPageViewTemplate.remove(query,MONGODB_COLLECTION_NAME);
        return true;
    }

    /**
     * 查询分析师信息
     * @param user
     * @param echoAutoDataDTO
     * @return
     */
    @Override
    public EchoAutoDataDTO queryAgileDataAutoData(AuthoredUser user,EchoAutoDataDTO echoAutoDataDTO) {
        if(echoAutoDataDTO == null){
            return null;
        }
        Query query = Query.query(Criteria.where("userId").is(user.getUserId())
                .and("tenantId").is(user.getTenantId())
                .and("messageId").is(echoAutoDataDTO.getMessageId()));
        if(StringUtils.isNotEmpty(echoAutoDataDTO.getStatus())){
            query.addCriteria(Criteria.where("status").is(echoAutoDataDTO.getStatus()));
        }
        return mongoAgileDataPageViewTemplate.findOne(query, EchoAutoDataDTO.class,MONGODB_COLLECTION_NAME);
    }
}
