package com.digiwin.athena.agiledataecho.util;

import com.digiwin.athena.appcore.util.JsonUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

import java.util.Locale;
import java.util.Map;

/**
 * @author chenxsa
 * 国际化工具类
 */
@Component
public class MessageUtil {

    @Autowired
    private MessageSource messageSource;

    public String getMessage(String langKey) {
        return messageSource.getMessage(langKey, null, LocaleContextHolder.getLocale());
    }


    public String getMessageByLangName(String langKey, String langName) {
        String lang = langName;
        if (StringUtils.isNotBlank(lang)) {
            lang = StringUtils.replaceChars(lang, '_', '-');
        }
        return messageSource.getMessage(langKey, null, Locale.forLanguageTag(lang));
    }

    public String getMessageWithFormat(String langKey, Object... paras) {
        return String.format(getMessage(langKey), paras);
    }

    public String getMessageByLangNameWithFormat(String langKey, String langName, Object... paras) {
        return String.format(getMessageByLangName(langKey, langName), paras);
    }

//    public static String getMessageByCurrentLanguage(Object langObject) {
//        String langName = LocaleContextHolder.getLocale().toLanguageTag();
//        return getMessageByLanguage(langObject, langName);
//    }

    public static String getMessageByLanguage(Object langObject, String langName) {
        if (langObject == null) {
            return "";
        }
        Map langMap = null;
        if (langObject instanceof String) {
            String valueText = langObject.toString();
            if (valueText.startsWith("{") && valueText.endsWith("}")) {
                try {
                    langMap = JsonUtils.jsonToObject(valueText, Map.class);
                } catch (Exception e) {
                    //说明不是json格式，返回原值
                    return valueText;
                }
            } else {
                return valueText;
            }
        } else if (langObject instanceof Map) {
            langMap = (Map) langObject;
        } else {
            return langObject.toString();
        }

        if (MapUtils.isNotEmpty(langMap)) {
            langName = langName.replace("-", "_");
            if (langMap.containsKey(langName)) {
                return (String) langMap.get(langName);
            }
        }

        return langObject.toString();
    }

//    public static void main(String[] args) {
//        System.out.println(getMessageByLanguage("{\"zh_CN\":\"简体\"}", "zh_CN"));
//        System.out.println(getMessageByLanguage("{\"key\":\"value\"}", "zh_CN"));
//    }

}

