package com.digiwin.athena.show.analyzer;

import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.util.MessageUtil;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.assistant.EchoShowConstants;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReport;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.service.AgileDataPageDefineService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * 敏捷报表解析器
 */
@Slf4j
@Service
public class AgileReportPageDefineAnalyzer {

    @Autowired
    protected MessageUtil messageUtils;

    @Autowired
    private List<AgileDataPageDefineService> pageDefines;

    private AgileDataPageDefineService getPageDefine(SnapDataDTO snapDataDTO){
        AgileDataPageDefineService agileDataPageDefineService = null;
        for(AgileDataPageDefineService pageDefine : pageDefines){
            String supportKey = "AGILEDATA_DEFINE_" + snapDataDTO.getSnapData().getQueryType();
            if(StringUtils.equals(pageDefine.supportKey(), supportKey)){
                agileDataPageDefineService = pageDefine;
                break;
            }
        }
        return agileDataPageDefineService;
    }



    public AgileReport analysis(ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        AgileReport agileReport;
        try {
            //根据查询方式获取敏捷数据处理定义
            AgileDataPageDefineService agileDataPageDefineService = this.getPageDefine(snapDataDTO);
            //获取敏捷数据定义
            agileReport = Objects.requireNonNull(agileDataPageDefineService).analysis(executeContext,snapDataDTO);
        } catch (BusinessException e){
            log.error("快照ID:{},解析敏捷数据呈现异常：{},{}",snapDataDTO.getSnapData().getSnapshotId(),e.getMessage(),e.toString());
            throw e;
        } catch (Exception e){
            log.error("快照ID:{},解析敏捷数据呈现异常：{},{}",snapDataDTO.getSnapData().getSnapshotId(),e.getMessage(),e.toString());
            throw BusinessException.create(ErrorCodeEnum.AGILE_REPORT_DATA_ERROR.getErrCode(),messageUtils.getMessageByLangName("P.AGILEDATAECHO.800.0004",executeContext.getLocale()));
        }

        if(agileReport == null || CollectionUtils.isEmpty(agileReport.getReport())){
            throw BusinessException.create(ErrorCodeEnum.AGILE_REPORT_EMPTY_DATA.getErrCode(), MessageUtils.getMessageByCurrentLanguage(EchoShowConstants.getLanMap("您所提问的数据呈现异常，请联系客服人员。","您所提問的數據呈現異常，請聯繫客服人員。","The data you asked is showing abnormalities. Please contact customer service.")));
        }
        return agileReport;
    }




}
