package com.digiwin.athena.show.assistant;

import com.google.common.collect.Maps;

import java.util.Map;

public class EchoShowConstants {

    /**
     * 客户端来源标识--移动端
     */
    public static final String MOBILE_PLATFORM = "mobileplatform";

    /**
     * web端
     */
    public static final String WEB_PLATFORM = "webplatform";

    public static final String PATTERN_REPORT_DATA = "AGILE-REPORT";

    public static final String LAN_CN = "zh_CN";

    public static final String LAN_TW = "zh_TW";

    public static final String LAN_US = "en_US";

    public static Map<String, Object> getLanMap(String cnMessage, String twMessage, String usMessage) {
        Map<String, Object> lanMap = Maps.newHashMap();
        lanMap.put(LAN_CN, cnMessage);
        lanMap.put(LAN_TW, twMessage);
        lanMap.put(LAN_US, usMessage);
        return lanMap;
    }

}
