package com.digiwin.athena.show.assistant;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jugg.agile.spring.boot.webmvc.util.JaSpringServletUtil;
import lombok.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 页面相关上下文
 **/

@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ExecuteContext {

    /**
     * 代理的token
     */
    private String proxyToken;

    /**
     * 登陆用户
     */
    @JsonIgnore
    private AuthoredUser authoredUser;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 语言别
     */
    private String locale;

    /**
     * 客户端来源
     */
    private String clientAgent;

    /**
     * 客户端类型 standardweb:标准前端web
     */
    private String agentType;


    /**
     * 执行者performer或者当责者charge
     */
    private String identity;





    /**
     * 页面场景
     * [project-card,project-detail,task-card,task-detail]
     */
    private String pageCode;


    /**
     * 任务、项目是否为被分享的
     */
    private Boolean isShared;


    /**
     * 调用链ID
     */
    private String traceId;



    /**
     * 敏捷报表ID
     */
    private Map<String, Object> agileData;

    /**
     * 敏捷报表定义Code
     */
    private String reportCode;

    /**
     * 快照ID
     */
    private String snapshotId;

    /**
     * 用户ID
     */
    private String performerId;

    /**
     * 数据获取方式
     */
    private String queryType;

    /**
     * 消息ID
     */
    private String messageId;

    /**
     * 请求入口
     */
    private String entry;

    /**
     * 架构链路
     */
    private String link;

    /**
     * 数据ID
     */
    private String actionId;

    /**
     * 大屏Code
     */
    private String screenCode;

    /**
     * 呈现区域数量规则
     */
    private String module;

    /**
     * 图表转换ID
     */
    private String transId;

    /**
     * 用户自定义标题
     */
    private String defineTitle;


    /**
     * 是否为平铺树结构TABLE
     */
    @JsonIgnore
    private Boolean isRowSpanTree;

    public Boolean getIsRowSpanTree() {
        if (isRowSpanTree == null) {
            isRowSpanTree = false;
        }
        return isRowSpanTree;
    }

    public void setIsRowSpanTree(Boolean isRowSpanTree) {
        this.isRowSpanTree = isRowSpanTree;
    }




    public <T extends ExecuteContext> void copyTo(T newExecuteContext) {
        newExecuteContext.setAuthoredUser(this.authoredUser);
        newExecuteContext.setClientAgent(this.clientAgent);
        newExecuteContext.setIsShared(this.isShared);
        newExecuteContext.setIdentity(this.identity);
        newExecuteContext.setLocale(this.locale);
        newExecuteContext.setPageCode(this.pageCode);
        newExecuteContext.setProxyToken(this.proxyToken);
        newExecuteContext.setTenantId(this.tenantId);
        newExecuteContext.setTraceId(this.traceId);
        newExecuteContext.setAgentType(this.agentType);
        newExecuteContext.setLink(this.link);
        newExecuteContext.setEntry(this.entry);
        newExecuteContext.setMessageId(this.messageId);
        newExecuteContext.setActionId(this.actionId);
    }

    public ExecuteContext clone() {
        ExecuteContext executeContext = new ExecuteContext();
        this.copyTo(executeContext);
        return executeContext;
    }


    public ExecuteContext appendHttpRequest(HttpServletRequest request) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty(clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        if (clientAgent == null) {
            clientAgent = EchoShowConstants.WEB_PLATFORM;
        }
        this.setClientAgent(clientAgent);
        this.setLocale(locale);
        AuthoredUser authoredUser = (AuthoredUser) request.getAttribute(GlobalConstant.AUTH_USER);
        this.setAuthoredUser(authoredUser);
        this.setTenantId(authoredUser.getTenantId());
        return this;
    }

    public static ExecuteContext createAppendByHttpRequest(ExecuteContext executeContext, HttpServletRequest request) {
        if (executeContext == null) {
            executeContext = ExecuteContext.createByHttpRequest(request);
        } else {
            executeContext.appendHttpRequest(request);
        }
        return executeContext;
    }

    public static ExecuteContext createByHttpRequest() {
        return createByHttpRequest(JaSpringServletUtil.getHttpServletRequest());
    }

    public static ExecuteContext createByHttpRequest(HttpServletRequest request) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        //S13后端分页大报文优化需求：
        //Client-Agent 目前已经被污染，app端有的接口也传的webplatform，没法区分了，所以新加一个Agent-Type，标准前端在调用uibot接口前，都会加上这个请求头
        //Agent-Type:standardweb 代表标准前端
        String agentType = StringUtils.isEmpty(request.getHeader("agent-type")) ? request.getHeader("Agent-Type") : request.getHeader("agent-type");
        if (StringUtils.isEmpty(clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        if (clientAgent == null) {
            clientAgent = EchoShowConstants.WEB_PLATFORM;
        }
        AuthoredUser authoredUser = (AuthoredUser) request.getAttribute(GlobalConstant.AUTH_USER);
        return ExecuteContext.builder()
                .clientAgent(clientAgent)
                .locale(locale)
                .authoredUser(authoredUser)
                .tenantId(authoredUser.getTenantId())
                .agentType(agentType)
                .build();
    }

    /**
     * 组装敏数上下文信息
     * @param pageCode
     * @param agileReportDTO
     */
    public void appendAgileDataPageInfo(String pageCode, SnapDataDTO agileReportDTO,String screenCode,String entry) {
        String actionId = agileReportDTO.getSnapData().getReportCode();
        if (StringUtils.isEmpty(actionId)) {
            List<String> actionIds = Lists.newArrayList();
            agileReportDTO.getPageData().forEach((k, v) -> actionIds.add(k));
            if (CollectionUtils.isNotEmpty(actionIds)) {
                actionId = actionIds.get(0);
            }
        }
        this.setIdentity(AgileDataConstants.PERFORMER);
        this.setPageCode(pageCode);
        this.setMessageId(agileReportDTO.getSnapData().getMessageId());
        this.setLink(agileReportDTO.getLink());
        this.setEntry(entry);
        this.setSnapshotId(agileReportDTO.getSnapData().getSnapshotId());
        this.setIsShared(Boolean.FALSE);
        this.actionId = actionId;
        this.screenCode = screenCode;
    }

    /**
     * 组装敏数上下文信息
     * @param pageCode
     * @param agileReportDTO
     */
    public void appendAgileDataPageInfo(String pageCode, SnapDataDTO agileReportDTO,String screenCode,String entry,String defineTitle) {
        String actionId = agileReportDTO.getSnapData().getReportCode();
        if (StringUtils.isEmpty(actionId)) {
            List<String> actionIds = Lists.newArrayList();
            agileReportDTO.getPageData().forEach((k, v) -> actionIds.add(k));
            if (CollectionUtils.isNotEmpty(actionIds)) {
                actionId = actionIds.get(0);
            }
        }
        this.setIdentity(AgileDataConstants.PERFORMER);
        this.setPageCode(pageCode);
        this.setMessageId(agileReportDTO.getSnapData().getMessageId());
        this.setLink(agileReportDTO.getLink());
        this.setEntry(entry);
        this.setSnapshotId(agileReportDTO.getSnapData().getSnapshotId());
        this.setIsShared(Boolean.FALSE);
        this.actionId = actionId;
        this.screenCode = screenCode;
        this.defineTitle = defineTitle;
    }






}
