package com.digiwin.athena.show.component;

import cn.hutool.core.text.CharPool;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * @description: 自动生成
 * @author: wangminga
 * @create: 2020-07-14 19:40
 **/
@Data
public class AbstractComponent {

    private String id;

    private String type;

    private String headerName;

    private String placeholder;

    private String title;

    private Boolean showIcon;

    /**
     * 当前字段所在的路径
     */
    private String path;

    /**
     * 当前字段所在层级
     */
    private Integer level;

    /**
     * 千分位标识
     * 目前前端不使用该属性进行千分位的显示。
     */
    private Boolean thousandthPercentile;

    /**
     * 样式
     */
    private String className;

    /**
     * 目前是规则 来获取的描述
     */
    private String description;

    /**
     * 组件是否只读；
     * 可用/禁用；true：禁用；false或null为可用；
     */
    private Boolean disabled;

    /**
     * 是否可编辑
     */
    private Boolean editable;

    /**
     * 字段类型
     */
    private String dataType;


    /**
     * 保留小数位
     */
    private Integer decimal;

    /**
     * 统一设置
     */
    private JSONObject setting;

    /**
     * 是否支持排序
     */
    private Boolean sortable;

    /**
     * 是否支持过滤
     */
    private Boolean filterable;

    /**
     * 行分组
     */
    private Boolean rowGroupable;

    /**
     * 是否显示group 下面栏位是否显示标题
     */
    private String showTitleIcon;

    /**
     * 用于标记开窗是否需要排他， 如果已经选择过，则不能再被选择
     * true：需要排他
     * false:不需要排他
     * 可以不配，不配默认false
     */
    private Boolean disabledSelected;

    /**
     * 用户标记是否支持最大化
     */
    private Boolean supportShowInMaxedWindow;

    /**
     * 组件高度，百分比
     */
    private String height;

    /**
     * 最小高度
     */
    private String minHeight;

    /**
     * 最大高度
     */
    private String maxHeight;

    /**
     * 用于前端控制用户自定义栏位上宽度
     */
    private Integer width;


    /**
     * 用于前端控制用户自定义栏位上是否隐藏
     * true 隐藏
     * false不隐藏
     */
    private Boolean hide;

    /**
     * 是否隐藏,用于前台进行组件隐藏，模型驱动的权限配置
     */
    private Boolean hidden;


    /**
     * 是否启用去掉字符串前后端空格
     */
    private Boolean enableTrim;

    /**
     * 焦点事件是否标题在外显示 false/空否 true是
     */
    private Boolean isFocusDisplay;

    /**
     * 关联字段
     */
    private List<String> relationSchemas;

    /**
     * 扩展参数，在需要做额外处理时可以使用
     */
    private Map<String, Object> extendParas;

    private Boolean important;

    /**
     * 指定字段（用在差异组件）
     * todo:不同的地方不同的用途,需要梳理重构
     */
    private List<Map<String, Object>> fields;

    /**
     * 下拉属性值
     */
    private List<Map<String, Object>> options;

    /**
     * 是否支持跳转
     * true:支持
     * false:不支持（default）
     */
    private Boolean isNavigate;


    /**
     * 增加最大行高的配置参数（≥1的整数）
     */
    private Integer maxRows;

    /**
     * 表格标题，title字段意义比较多，新开一个字段
     */
    private String tableTitle;


    /**
     * 表单是否可以折叠
     * true:可以折叠，false：不能折叠
     */
    private Boolean collapse;

    /**
     * 是否为客制
     */
    private Boolean isCustom;



    /**
     * 设置可编辑和非禁用
     *
     * @param editable 是否可编辑
     */
    public void setEditableDisabled(boolean editable) {
        this.setEditable(editable);
        this.setDisabled(!editable);
    }

    public void setHeightIfNotEmpty(String height) {
        if (StringUtils.isNotBlank(height)) {
            this.setHeight(height);
        }
    }

    @Override
    public String toString() {
        return this.getType() + ":" + this.getHeaderName();
    }
}
