package com.digiwin.athena.show.component.card;

import com.digiwin.athena.show.component.AbstractComponent;
import lombok.Getter;
import lombok.Setter;

/**
 * 卡片组件
 */

/**
 * @Author: SunHong
 * @Date: 2024/8/8 10:08
 * @Description: 卡片组件
 */
@Setter
@Getter
public class CardComponent extends AbstractComponent {

    /**
     * 头部区域
     */
    private CardHeader header;

    /**
     * 内容区域
     */
    private CardBody body;

    /**
     * 底部区域
     */
    private CardFooter footer;

    /**
     * 是否要边框
     */
    private String noBorder;

    /**
     * 边框16进制颜色值
     */
    private String borderColor;

    /**
     * 鼠标移入效果
     */
    private String hoverable;

    /**
     *  显示阴影
     */
    private Boolean hasShadow;



}
