package com.digiwin.athena.show.component.echarts;

import com.digiwin.athena.show.component.CommonComponent;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.Option;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * eCharts组件
 */
@Data
public class EchartsComponent extends CommonComponent {

    /**
     * 图表类型
     */
    private EChartsTypeEnum reportType;

    /**
     * 图表结构
     */
    private EChartsOption eChartsOption;

    /**
     * 移动端图表展示
     */
    private ChartBase chartBase;

    /**
     * 呈现类型
     */
    private Integer chartType;

    /**
     * 原始呈现类型
     */
    private Integer sourceChartType;

    /**
     * 图表结构
     */
    private Option option;



    @Data
    public static class EChartsOption {

        /**
         * 标题
         */
        private Title title;

        /**
         * x轴内容
         */
        private EChartsXAxisDTO xAxis;

        /**
         * y轴内容
         */
        private EChartsXAxisDTO yAxis;

        /**
         * 主体内容
         */
        private List<EChartsSeriesDTO> series;

        /**
         * 样式
         */
        private Object style;

        /**
         * 提示
         */
        private ToolTip tooltip;


        /**
         * 图标
         */
        private Legend legend;

        /**
         * 切换
         */
        private ToolBox toolbox;


        public EChartsXAxisDTO getxAxis() {
            return xAxis;
        }

        public void setxAxis(EChartsXAxisDTO xAxis) {
            this.xAxis = xAxis;
        }

        public EChartsXAxisDTO getyAxis() {
            return yAxis;
        }

        public void setyAxis(EChartsXAxisDTO yAxis) {
            this.yAxis = yAxis;
        }


        public ToolTip getTooltip() {
            return tooltip;
        }

        public void setTooltip(ToolTip tooltip) {
            this.tooltip = tooltip;
        }

        @Data
        public static class Title{
            private String text;

            private Object textStyle;
        }

        @Data
        public static class ToolTip{

            private String trigger;
        }

        @Data
        public static class Legend{

            private String orient;

            private String top;
        }

        @Data
        public static class ToolBox{

            private Boolean show;

            private EChartFeature feature;

            private String left;

            @Data
            public static class EChartFeature{

                private EChartMagicType magicType;

                @Data
                private static class EChartMagicType{

                    private Boolean show;

                    private List<String> type;

                    private Map<String,String> title;
                }

            }
        }
    }

}
