package com.digiwin.athena.show.component.echarts;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.show.component.AbstractComponentService;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportECharts;
import com.digiwin.athena.show.infrastructure.component.ComponentNameConstants;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileReportRuleService;
import com.digiwin.athena.show.service.ChartBuildBase;
import digiwin.chartsdk.beans.sdk.chart.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * echarts组件
 */
@Service(ComponentNameConstants.ECHARTS)
public class EchartsComponentImpl extends AbstractComponentService {

    private static final String COMPONENT_TYPE = "ECHARTS";

    @Autowired
    private AgileReportRuleService agileReportRuleService;




    public EchartsComponent initComponent(MetadataField metadataField, BuildContext buildContext) {
        EchartsComponent echartsComponent = new EchartsComponent();
        echartsComponent.setType(COMPONENT_TYPE);
        echartsComponent.setId(buildContext.getThemeMapReport().getActionId());
        echartsComponent.setTitle(buildContext.getThemeMapReport().getECharts().getTitle());
        echartsComponent.setChartType(buildContext.getThemeMapReport().getReportShow());

        AgileReportECharts agileReportECharts = buildContext.getThemeMapReport().getECharts();

        if(agileReportECharts != null){
            echartsComponent.setSourceChartType(agileReportECharts.getSourceChartType());
            Option option = this.buildEChartsParams(metadataField, buildContext);
            echartsComponent.setOption(option);
        }

        return echartsComponent;
    }



    //构建图表
    private Option buildEChartsParams(MetadataField metadataField, BuildContext buildContext){
        ChartBuildBase chartBuildBase = SpringUtil.getBean("chart_"+buildContext.getThemeMapReport().getECharts().getChartType(), ChartBuildBase.class);
        Option option = chartBuildBase.buildChart(metadataField,buildContext);
        return option;
    }



}
