package com.digiwin.athena.show.component.grid;

import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.CommonComponent;
import com.digiwin.athena.show.component.ComponentFormat;
import com.digiwin.athena.show.component.ContainComponent;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataMobileGridColumnDef;
import com.digiwin.athena.show.metadata.MetadataField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.apache.commons.compress.utils.Lists;

import java.util.List;
import java.util.Map;

/**
 * @description: grid栏位
 * @author: wangminga
 * @create: 2020-05-26 16:08
 **/
@Data
public class GridColumnDef extends CommonComponent implements ContainComponent<AbstractComponent> {

    /**
     * 字段名称
     */
    private String name;

    /**
     * 列组件
     */
    private List<AbstractComponent> columns;


    /**
     * 呈现格式化规则
     */
    private ComponentFormat format;

    /**
     * 获取所有子组件
     *
     * @return
     */
    @JsonIgnore
    @Override
    public List<AbstractComponent> getSubComponents() {
        return columns;
    }


}
