package com.digiwin.athena.show.component.grid;

import com.digiwin.athena.show.metadata.MetadataField;
import org.apache.commons.collections.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class WidthCalculator {

    public static final String BUTTON_GROUP_COMPONENT_TYPE = "BUTTON_GROUP";

    // 列最大宽度
    public static final int COL_MAX_WIDTH = 400;

    public static void calColumnWidth(List<MetadataField> metadataFields, List<Map<String,Object>> pageData) {
        if (CollectionUtils.isEmpty(metadataFields)) {
            return;
        }
        //暂时只统计前20行数据
        int maxRow = 20;
        //汉字宽度
        double chCharWidth = 13;
        //大小写，数字
        double enCharWidth = 8;
        //其他符号
        int otherCharWidth = 7;

        int paddingWidth = 16;
        int headerIconWidth = 34;
        //如果有多列，则多显示一个icon
        int multiColumnIconWidth = 17;

        if (pageData != null
                && pageData.size() > 0) {
            if (pageData.size() < 20) {
                maxRow = pageData.size();
            }
            //取前20笔数据来决定最大显示宽度
            CharCounter charCounter = new CharCounter();

            pageData.stream()
                    .limit(maxRow)
                    .forEach(data -> {
                        for (MetadataField field : metadataFields) {
                            if (!data.containsKey(field.getName())) {
                                return;
                            }
                            Object value = data.get(field.getName());
                            if (value == null) {
                                return;
                            }
                            if (value instanceof Map || value instanceof Collection) {
                                return;
                            }
                            CharCounter.Result result = charCounter.count(value.toString());
                            if (result != null) {
                                int width = (int) Math.ceil(result.getChCharacter() * chCharWidth + result.getEnUpCharacter() * chCharWidth + result.getEnNumberSpaceCharacter() * enCharWidth + +result.getOtherCharacter() * otherCharWidth);
                                field.setDisplayWidth(width + field.getDisplayWidth());
                            }
                        }
                    });
        }
        for (MetadataField field : metadataFields) {
            if (field.getDisplayWidth() > 0) {
                field.setDisplayWidth((int) Math.ceil((field.getDisplayWidth() * 1d) / (maxRow * 1d)));
            }
        }
        for (MetadataField metadataField : metadataFields) {
            int maxWidth = 0;
            if (metadataField.getDescription() != null) {
                maxWidth = (int) Math.ceil(metadataField.getDescription().length() * chCharWidth) + headerIconWidth;
            }


            if (CollectionUtils.isNotEmpty(metadataField.getSubFields())
                && metadataField.getSubFields().size() > 1) {
                maxWidth += multiColumnIconWidth;
            }

            boolean needSetWidth = false;
            if (CollectionUtils.isNotEmpty(metadataField.getSubFields())) {
                if (metadataField.getSubFields().size() > 1) {
                    maxWidth += multiColumnIconWidth;
                }
                for (MetadataField subField : metadataField.getSubFields()) {
                    if (subField.getDisplayWidth() > 0) {
                        needSetWidth = true;
                        if (subField.getDisplayWidth() > maxWidth) {
                            maxWidth = subField.getDisplayWidth();
                        }
                    }
                }
            } else {
                if (metadataField.getDisplayWidth() > 0) {
                    needSetWidth = true;
                    if (metadataField.getDisplayWidth() > maxWidth) {
                        maxWidth = metadataField.getDisplayWidth();
                    }
                }
            }
            if (metadataField.getDisplayWidth() == 0 || needSetWidth) {
                int displayWidth = maxWidth + paddingWidth;
                widthLimit(metadataField, displayWidth);
            }
        }
    }

    /**
     * 设置字段组宽度，且不能超过400
     *
     * @param displayWidth 显示宽度
     * @return
     */
    public static void widthLimit(MetadataField metadataField, int displayWidth) {
        metadataField.setDisplayWidth(Math.min(displayWidth, COL_MAX_WIDTH));
    }



}
