package com.digiwin.athena.show.component.gridster;

import lombok.Data;


@Data
public class GridGroupDTO {

    private String id;
    /**
     * 单元格横坐标
     */
    private Integer x;
    /**
     * 单元格的纵坐标
     */
    private Integer y;
    /**
     * 单元格占据的行数量（高度）
     */
    private Integer rows;
    /**
     * 单元格占据的列数量（宽度）
     */
    private Integer cols;

    private String type;


    private String title;

    /**
     * 数据入口
     */
    private String entry;

    /**
     * 单元格占据的最小行数量（高度）
     */
    private Integer minItemRows;
    /**
     * 单元格占据的最小列数量（宽度）
     */
    private Integer maxItemRows;
    /**
     * 单元格占据的最大行数量（高度）
     */
    private Integer minItemCols;
    /**
     * 单元格占据的最大列数量（宽度）
     */
    private Integer maxItemCols;
    /**
     * 开启/禁用 内容项尺寸。
     */
    private Boolean resizeEnabled;
    /**
     * 开启/禁用 内容项拖拽。
     */
    private Boolean dragEnabled;

    /**
     * 对应自组件id
     */
    private String targetId;

    /**
     * 是否隐藏单元格内部组件的滚动条
     */
    private String cellOverflow;

    /**
     * 是否自定义布局
     */
    private Boolean userDefined = false;

}
