package com.digiwin.athena.show.component.gridster;

import lombok.Data;

/**
 * @author gengwei
 * @date 2024/6/21 13:47
 */
@Data
public class GridsterOption {
    /**
     * fit	自适应模式，不会出现滚动条，容器自适应、单元格自适应、内容项自适应。
     * scrollVertical	自适应模式衍生，横向自适应模式，会出现纵向滚动条。
     * scrollHorizontal	自适应模式衍生，纵向自适应模式，会出现横向滚动条。
     * fixed	        固定模式，单元格尺寸基于fixedColWidth、fixedRowHeight，可能会出现滚动条。
     * verticalFixed	固定模式衍生，纵向固定模式，基于fixedRowHeight，可能会出现纵向滚动条。
     * horizontalFixed	固定模式衍生，横向固定模式，基于fixedColWidth，可能会出现横向滚动条。
     */
    private String gridType;


    /**
     * 去除容器外边框
     */
    private Boolean outerMargin;

    /**
     * 固定列宽，适用于fixed、horizontalFixed。
     */
    private Integer fixedColWidth;

    /**
     * 固定行高，适用于fixed、verticalFixed。
     */
    private Integer fixedRowHeight;

    /**
     * 根据内容项，设置容器尺寸，适用于fixed、verticalFixed、horizontalFixed。
     */
    private Boolean setGridSize;

    /**
     * 网格最小列数量。
     */
    private Integer minCols;
    /**
     * 网格最大列数量。
     */
    private Integer maxCols;
    /**
     * 网格最小行数量。
     */
    private Integer minRows;
    /**
     * 网格最大行数量。
     */
    private Integer maxRows;

    /**
     * 单元格间距，margin为0时，不显示间距
     */
    private Integer margin;
    /**
     * 允许item在移动到到另一个上面时切换位置。
     */
    private Boolean swap;
    /**
     * 调整大小和拖动时的配置。
     */
    private Boolean pushItems;

    /**
     * 操作后是否调用api保存配置
     */
    private Boolean saveSetting;

    /**
     * 行和列的背景网格的显示模式。
     * always：总是显示
     * onDrag&Resize：拖拽和缩放的时候显示
     * none：总是不显示
     */
    private String displayGrid;


}
