package com.digiwin.athena.show.component.index;

import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.ComponentFormat;
import com.digiwin.athena.show.component.DataAnalysisField;
import lombok.Data;

import java.util.List;

/**
 * 指标卡
 */
@Data
public class AgileDataIndexComponent extends AbstractComponent {

   private List<AgileDataIndex> group;

    @Data
    public static class AgileDataIndex{
        private String name;

        private Object value;

        /**
         * 提示词
         */
        private String tip;

        /**
         * 格式化配置
         */
        private ComponentFormat format;

        /**
         * 关联维度
         */
        private List<DataAnalysisField> dimensionData;

        /**
         * 关联度量
         */
        private List<DataAnalysisField> measurementData;
    }

}
