package com.digiwin.athena.show.component.list;

import com.digiwin.athena.show.component.AbstractComponent;
import lombok.*;

import java.util.List;
import java.util.Map;

/**
 * 列表组件
 */

@Data
public class ListComponent extends AbstractComponent {

    /**
     * 自适应模式
     */
    private Boolean isFit;

    /**
     * "horizontal | vertical"排列方式
     */
    private String itemsLayout;

    /**
     * 分页相关
     */
    private Map<String,Object> pagination;

    /**
     * 分组相关
     */
    private Map<String,Object> subset;

    /**
     * 自定义样式，背景等
     */
    private Map<String,Object> style;

    /**
     * item间距
     */
    private String itemMargin;

    /**
     *  list的每一项item里面的内容
     */
    private List<AbstractComponent> group;

    /**
     * 背景颜色
     */
    private String bgColor;

    /**
     * 是否拖动
     */
    private Boolean isDraggable;

    /**
     * 分组字段
     */
    private String groupByField;

    /**
     * 排序主键，默认为projectId
     */
    private String sortField;


    /**
     * 分割线
     */
    private Boolean split;

    /**
     * 是否栅格布局
     */
    private Boolean isGrid;

    /**
     * 一行展示多少列 isGrid === true 生效
     */
    private Integer gridCount;

    private GridBreakPointSet gridBreakPointSet;

    /**
     * 每项间隔 isGrid === true 生效
     */
    private Integer gridGutter;

    /**
     * 边距
     */
    private String listPadding;

    /**
     * 展示加载缺省图
     */
    private Boolean loading;

    /**
     * 展示加载失败缺省图
     */
    private Boolean fallback;



    @Setter
    @Getter
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class GridBreakPointSet {
        //750px 以下 显示列数
        private Integer xs;
        //751px - 1200px 显示列数
        private Integer sm;
        //1201px - 1440px 显示列数
        private Integer md;
        //1441px - 1700px 显示列数
        private Integer lg;
        //1701px - 1920px 显示列数
        private Integer xl;
        // 1920px 以上 显示列数
        private Integer xxl;
    }

}
