package com.digiwin.athena.show.controller;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.analysis.AnalysisFluctuateReq;
import com.digiwin.athena.show.service.AgileDataAnalysisService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/api/ai/v1/analysis/")
public class AgileDataAnalysisController {

    @Autowired
    private AgileDataAnalysisService agileDataAnalysisService;

    /**
     * 归因分析-数据波动
     * @param analysisFluctuateReq
     * @return
     */
    @PostMapping("show/attributionAnalysis")
    public ResponseEntity<?> attributionAnalysis(@RequestBody AnalysisFluctuateReq analysisFluctuateReq) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest();
        return ResponseEntityWrapper.wrapperOk(agileDataAnalysisService.getAnalysisDataSummary(analysisFluctuateReq,executeContext.getLocale()));
    }

    /**
     * 归因分析-维度分析
     * @param analysisFluctuateReq
     * @return
     */
    @PostMapping("show/dimensionAttribution")
    public ResponseEntity<?> dimensionAttribution(@RequestBody AnalysisFluctuateReq analysisFluctuateReq) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest();
        return ResponseEntityWrapper.wrapperOk(agileDataAnalysisService.getAnalysisDataDimension(analysisFluctuateReq,executeContext.getLocale()));
    }

}
