package com.digiwin.athena.show.controller;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.show.domain.ppt.AgileDataFileDTO;
import com.digiwin.athena.show.domain.ppt.AgileDataFileQueryReq;
import com.digiwin.athena.show.service.ppt.AgileDataFileManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/api/ai/v1/file/")
public class AgileDataFileManagerController {

    @Autowired
    private AgileDataFileManagerService agileDataFileManagerService;

    /**
     * PPT分析规划问句查询
     * @param agileDataFileQueryReq
     * @return
     */
    @PostMapping("getAgileDataFile")
    public ResponseEntity<?> getAgileDataFile(@RequestBody AgileDataFileQueryReq agileDataFileQueryReq,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileDataFileManagerService.queryAgileDataFile(user,agileDataFileQueryReq));
    }

    /**
     * PPT分析规划问句新增
     * @param agileDataFileDTO
     * @return
     */
    @PostMapping("addAgileDataFile")
    public ResponseEntity<?> addAgileDataFile(@RequestBody AgileDataFileDTO agileDataFileDTO,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileDataFileManagerService.saveAgileDataFile(user,agileDataFileDTO));
    }

    /**
     * PPT分析规划问句修改
     * @param agileDataFileDTO
     * @return
     */
    @PostMapping("updateAgileDataFile")
    public ResponseEntity<?> updateAgileDataFile(@RequestBody AgileDataFileDTO agileDataFileDTO,
                                              @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileDataFileManagerService.updateAgileDataFile(user,agileDataFileDTO));
    }

    /**
     * PPT分析规划问句删除
     * @param agileDataFileQueryReq
     * @return
     */
    @PostMapping("deleteAgileDataFile")
    public ResponseEntity<?> deleteAgileDataFile(@RequestBody AgileDataFileQueryReq agileDataFileQueryReq,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileDataFileManagerService.deleteAgileDataFile(user,agileDataFileQueryReq));
    }



}
