package com.digiwin.athena.show.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @description: Tag 定义
 **/
@Data
public class TagDefinition {
    /**
     * tag 编码
     */
    private String code;

    /**
     * tag的父类集合
     */
    private List<String> parentTagNames;

    /**
     * 显示名称
     */
    private Object title;

    /**
     * tag 名称
     */
    private String name;


    /**
     * tag 描述
     */
    private String description;

    /**
     * 类型
     * BUSINESS
     * GROUP
     * ORDER
     */
    private String category;

    /**
     * 解析服务名称
     */
    private String interpreterServiceName;


    /**
     * 权重值 主要用于排斥属性 优先使用哪个TAG上的值
     */
    private Integer executionWeight;


    /**
     * 是否是自定义，如果是自定义标签，那么只是显示，权重为0
     * 1.权重值0
     * 2.如果有其他标签存在 直接废弃
     * 3.如果只有本标签，那么就是只是单独显示使用，不做任何处理
     */
    private Boolean customize;

    /**
     * 应用到字段  不在UI-BOT 运行时处理
     */
    private String applyTo;

    /**
     * 扩展信息
     */
    private Map<String, Object> extendedInfo;

    /**
     * 多语言
     */
    private Object lang;
    /**
     * TM定义的编码
     */
    private String tmTagCode;


    /**
     * 是否椒默认的tag
     */
    @JsonIgnore
    private boolean defaultTag;

    /**
     * 是否累加
     */
    private boolean append;




}
