package com.digiwin.athena.show.domain.agileDataDTO;

import com.digiwin.athena.show.metadata.ApiMetadata;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 敏捷数据过滤器
 */
@Data
public class AgileDataFilter {

    /**
     * 数据源ID
     */
    private String actionId;

    /**
     * 筛选元数据
     */
    private ApiMetadata apiMetadata;

    /**
     * 规则
     */
    private AgileReportRuleDTO agileReportRule;

    /**
     * 业务数据
     */
    private List<Map<String,Object>> pageData;

    /**
     * 关联字段
     */
    private String correlationField;
}
