package com.digiwin.athena.show.domain.agileDataDTO;

import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;

/**
 * 区域分组对象
 */
@Data
public class AgileDataGridsterGroup {

    /**
     * 区域整体宽度
     */
    private int width;

    /**
     * 翦整体高度
     */
    private int height;

    /**
     * 区域排列方向
     */
    private String direction = "line";

    /**
     * 区域集合
     */
    private List<AgileDataGridsterArea> areas = Lists.newArrayList();

    /**
     * 设置当前区域宽高
     */
    public void setSize(){
        this.width = 0;
        this.height = 0;
        Optional<AgileDataGridsterArea> maxWidthOptional = areas.stream().max(Comparator.comparing(AgileDataGridsterArea::getCols));
        areas.stream().forEach(area -> {
            if (StringUtils.equals("line", direction)) {
                this.width += area.getCols();
                //每行高度都一致
                this.height = area.getRows();
            } else {
                if (maxWidthOptional.isPresent()) {
                    this.width = maxWidthOptional.get().getCols();
                } else {
                    this.width = area.getCols();
                }
                //所有行累加
                this.height += area.getRows();
            }
        });
    }

    /**
     * 重新计算分组宽高
     */
    public void reSize(int arrangeSize,int maxWidthSize){
        //按最高宽度计算当前区域宽高
        this.areas.stream().forEach(area -> area.reSizeProportion(arrangeSize,maxWidthSize));
        //重新计算区域高度
        this.setSize();
    }

    /**
     * 补齐当前组宽高
     */
    public void completionSize(int arrangeSize,int prevGroupWidth,boolean isLast){
        //最后一层区域分组，按宽度补齐
        if(isLast){
            areas.stream().forEach(area ->  {
                if(!StringUtils.equals("STATISTIC",area.getComponent().getType())) {
                    area.reSize(arrangeSize, prevGroupWidth);
                }
            });
        } else {
            //非最后一层区域分组，按当前组宽度补齐
            areas.stream().forEach(area -> {
                if(!StringUtils.equals("STATISTIC",area.getComponent().getType())) {
                    area.reSize(this.width,0);
                }
            });
        }
        //补齐完成后，重新计算区域宽高
        this.setSize();
    }

    public void calcCoordinate(int prevWidth,int prevHeight){
        for(AgileDataGridsterArea area : this.areas) {
            area.setX(prevWidth);
            area.setY(prevHeight);
            //组内如果是纵向排，需累加坐标高度
            if(StringUtils.equals("row",this.direction)) {
                prevHeight += area.getRows();
            }
        }
    }



}
