package com.digiwin.athena.show.domain.agileDataDTO;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.athena.show.component.grid.GridColumnDef;
import com.digiwin.athena.show.domain.TagDefinition;
import com.digiwin.athena.show.metadata.MetadataField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Data
public class AgileDataMobileGridColumnDef extends GridColumnDef {

    private String businessType;

    private String percent;

    private Map<String,Object> decimalRule;

    private Map<String,Object> unit;

    private String schema;

    private List<TagDefinition> tagDefinitions;


    /**
     * 获取移动端数据结构
     * @param metadataField
     * @param dataSource
     * @param width
     * @return
     */
    @JsonIgnore
    public void getMobilelGridColumn(MetadataField metadataField, String dataSource, Integer width){
        this.setHeaderName(metadataField.getDescription());
        this.setPath(dataSource);
        this.setLevel(0);
        this.setSortable(false);
        this.setFilterable(false);
        this.setOptions(Lists.newArrayList());
        this.setWidth(width);

        AgileDataMobileGridColumnDef columnDef = new AgileDataMobileGridColumnDef();
        columnDef.setType("LABEL");
        columnDef.setSchema(metadataField.getName());
        columnDef.setHeaderName(metadataField.getDescription());
        columnDef.setPath(dataSource);
        columnDef.setLevel(0);
        columnDef.setDataType(metadataField.getDataType());
        columnDef.setRowGroupable(true);
        columnDef.setWidth(width);
        columnDef.setRelationSchemas(Arrays.asList(metadataField.getName()));
        //tag
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setCustomize(false);
        tagDefinition.setAppend(false);
        tagDefinition.setCategory("DATATYPE");
        setTagType(metadataField.getDataType(),tagDefinition);
        columnDef.setTagDefinitions(Arrays.asList(tagDefinition));

        columnDef.setPercent(metadataField.getPercent());
        columnDef.setDecimal(metadataField.getDecimal());
        //加入业务标识属性
        if (StringUtils.isNotEmpty(metadataField.getBusinessType())){
            columnDef.setBusinessType(metadataField.getBusinessType());
        }
        if (StringUtils.isNotEmpty(metadataField.getDecimalRule())) {
            columnDef.setDecimalRule(BeanUtil.beanToMap(ConvertAgileDataUtils.getDecimalRule(metadataField.getDecimalRule())));
        }
        if (StringUtils.isNotEmpty(metadataField.getUnit())) {
            columnDef.setUnit(BeanUtil.beanToMap(ConvertAgileDataUtils.getUnitRule(metadataField.getUnit())));
        }
        this.setColumns(Arrays.asList(columnDef));
    }

    @JsonIgnore
    private void setTagType(String type,TagDefinition tagDefinition) {
        if (type.equals("string")) {
            tagDefinition.setCode("TYPE_STRING");
            tagDefinition.setInterpreterServiceName("typeStringTagInterpreter");
        }
        if (type.equals("date")) {
            tagDefinition.setCode("TYPE_DATE");
            tagDefinition.setInterpreterServiceName("typeDateTagInterpreter");
        }
        if (type.equals("numeric")) {
            tagDefinition.setCode("TYPE_NUMERIC");
            tagDefinition.setInterpreterServiceName("typeNumericTagInterpreter");
        }
    }


}
