package com.digiwin.athena.show.domain.agileDataDTO;

import com.google.common.collect.Lists;
import lombok.Data;

import java.util.List;

@Data
public class AgileDataScreenModel {

    /**
     * 模型ID
     */
    private String  modelId;

    /**
     * 布局结构
     */
    private List<ScreenModel> models = Lists.newArrayList();

    @Data
    public static class ScreenModel {
        /**
         * 单元格横坐标
         */
        private Integer x;
        /**
         * 单元格的纵坐标
         */
        private Integer y;


        /**
         * 单元格占据的列数量（宽度）
         */
        private Integer cols;

        /**
         * 单元格占据的行数量（高度）
         */
        private Integer rows;
    }



}
