package com.digiwin.athena.show.domain.agileDataDTO;

import lombok.Data;

import java.util.List;

@Data
public class AgileModelCenterDefine {

    /**
     * 模型ID
     */
    private String modelId;

    /**
     * 是否去重
     */
    private Boolean distinct;

    /**
     * 预设条件固定字段
     */
    private List<String> fixedFields;

    /**
     * 维度字段
     */
    private List<AgileModelCenterDimension> dimensions;

    /**
     * 度量字段
     */
    private List<AgileModelCenterMeasure> measures;

    /**
     * 过滤器配置
     */
    private AgileModelCenterFilter filter;

    /**
     * 排序字段
     */
    private List<AgileModelCenterSortField> sortFields;

    /**
     * 运算列
     */
    private List<AgieModelCenterComputedField> computedFields;

    /**
     * 入参配置
     */
    private List<AgileModelCenterParam> params;

    /**
     * 呈现样式
     * bar 柱图、line 线图、scatter 散点图、funnel 漏斗图、pie 饼图、gauge 路径图、card 指标卡、table 表格
     */
    private String chartType;
}
