package com.digiwin.athena.show.domain.agileDataDTO;

import com.digiwin.athena.show.domain.showDefine.DataSourceBase;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 敏捷报表定义
 */
@Data
public class AgileReport {

    /**
     * 敏捷报表code
     */
    private String reportCode;

    /**
     * 报表定义
     */
    private List<ThemeMapReport> report;

    /**
     * 标题
     */
    private String title;

    /**
     * 维度区间
     */
    private Map<String,Object> dimensionInterval;

    /**
     * 时间粒度
     */
    List<AgileDataAliasGrainDTO> aliasGrain;

    /**
     * 数据源
     */
    private DataSourceBase dataSourceBase;

}
