package com.digiwin.athena.show.domain.agileDataDTO;

import org.apache.commons.lang.StringUtils;

public enum AgileReportChartTypeEnum {

    /**
     * 不等宽柱形图
     */
    BAR_1("不等宽柱形图","bar",3),
    /**
     * 柱形图
     */
    BAR_2("柱形图","bar",3),

    BAR_3("直方图","bar",3),

    CATEGORY_1("堆积柱形图","category",null),

    CATEGORY_LINE_1("堆积百分比柱形图","category",null),

    LINE_1("曲线图","line",5),

    MIXED("混合图","mixed",4),

    PIE_1("饼图","pie",6),

    BAR_4("横条图","line-bar",7),

    SCATTER_1("散点图","scatter",8),

    SCATTER_2("气泡图","bubble",9);

    private String type;

    private String name;

    private Integer value;

    public String getType() {
        return type;
    }

    public Integer getValue() {
        return value;
    }

    AgileReportChartTypeEnum(String name, String type, Integer value){
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public static String getType(String name) {
        for(AgileReportChartTypeEnum agileReportChartTypeEnum : AgileReportChartTypeEnum.values()){
            if(StringUtils.equals(agileReportChartTypeEnum.name,name)){
                return agileReportChartTypeEnum.type;
            }
        }
        return null;
    }

    public static String getTypeByValue(Integer value) {
        for(AgileReportChartTypeEnum agileReportChartTypeEnum : AgileReportChartTypeEnum.values()){
            if(value.equals(agileReportChartTypeEnum.value)){
                return agileReportChartTypeEnum.type;
            }
        }
        return null;
    }

    public static Integer getValueByType(String type) {
        for(AgileReportChartTypeEnum agileReportChartTypeEnum : AgileReportChartTypeEnum.values()){
            if(type.equals(agileReportChartTypeEnum.type)){
                return agileReportChartTypeEnum.value;
            }
        }
        return null;
    }


}
