package com.digiwin.athena.show.domain.agileDataDTO;

import com.digiwin.athena.agiledataecho.dto.aiBoard.AIBoardLayout;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.gridster.GridGroupDTO;
import com.digiwin.athena.show.domain.board.BoardLayoutMongoData;
import com.digiwin.athena.show.manager.themeMap.domain.ThemeMapBoardDTO;
import com.digiwin.athena.show.util.layout.AgileDataGridsterBestShow;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * 敏捷数据呈现布局
 */
public class ConvertAgileDataRelation{

    private ConvertAgileDataRelation() {
        throw new IllegalStateException("Utility class");
    }



    private static List<String> sortComponent = Lists.newArrayList("LABEL","STATISTIC","ECHARTS","ATHENA_TABLE","PANEL","LIST","CARD");
    /**
     * 敏捷数据呈现
     * @param agileDataRelationDTOList
     * @return
     */
    public static List<GridGroupDTO> gridGroupDTOS(List<AgileDataRelationDTO> agileDataRelationDTOList,
                                                   List<AgileDataBestShowRule> bestShowRules, List<AbstractComponent> abstractComponents, ExecuteContext executeContext) {
        Map<String,Object> agileDataMap = executeContext.getAgileData();
        //大屏算法
        if(MapUtils.isNotEmpty(agileDataMap) && agileDataMap.containsKey("entry")){
            String entry = MapUtils.getString(agileDataMap,"entry");
            if(StringUtils.equals("1",entry)){
                return AgileDataGridsterBestShow.createItems(agileDataRelationDTOList,abstractComponents,executeContext);
            }
        }
        //非大屏算法
        return createItems(agileDataRelationDTOList,bestShowRules,abstractComponents,null);
    }

    /**
     * 场景区域对象
     * @param agileDataRelationDTOList
     * @return
     */
    public static List<GridGroupDTO> createItems(List<AgileDataRelationDTO> agileDataRelationDTOList,
                                                 List<AgileDataBestShowRule> bestShowRules,
                                                 List<AbstractComponent> components,
                                                 BoardLayoutMongoData userDefineLayout) {
        List<GridGroupDTO> gridGroupDTOList = Lists.newArrayList();
        //获取所有组件
        List<AbstractComponent> abstractComponents = Lists.newArrayList();
        if(CollectionUtils.isNotEmpty(agileDataRelationDTOList)) {
            agileDataRelationDTOList.stream().forEach(agileDataRelationDTO -> {
                if (agileDataRelationDTO.getAbstractComponents() != null) {
                    abstractComponents.addAll(agileDataRelationDTO.getAbstractComponents());
                }
            });
        }
        if(CollectionUtils.isEmpty(abstractComponents) && CollectionUtils.isNotEmpty(components)) {
            abstractComponents.addAll(components);
        }
        //按组件类型分组
        Map<String, List<AbstractComponent>> abstractComponentMap = abstractComponents.stream().collect(Collectors.groupingBy(AbstractComponent::getType));
        //生成行
        List<AgileDataGridsterArrange> arranges = Lists.newArrayList();
        //按组件顺序生成结构

        for(String sort : sortComponent) {
            if(abstractComponentMap.containsKey(sort)){
                //计数器，每次只会取同一种类型，不用担心串用
//                int size = 0;
                //生成行
                AgileDataGridsterArrange agileDataGridsterArrange = new AgileDataGridsterArrange();
                // 组件防重添加标记,当前行继续添加元素时，无需另起一行
                Boolean isAdd = false;
                //每个组件生成一块区域
                for(AbstractComponent abstractComponent : abstractComponentMap.get(sort)) {
                    //区域初始化
                    AgileDataGridsterArea area = new AgileDataGridsterArea(abstractComponent,null);
                    //是否存在自定义指标，存在则覆盖默认区域坐标
                    GridGroupDTO userDefineGroup = getUserDefineGroup(userDefineLayout,abstractComponent.getId());
                    if(userDefineGroup != null){
                        area.setSize(userDefineGroup.getCols(),userDefineGroup.getRows());
                    } else {
                        area.setSize();
                    }
                    //分组初始化
                    AgileDataGridsterGroup agileDataGridsterGroup = new AgileDataGridsterGroup();
                    agileDataGridsterGroup.getAreas().add(area);
                    agileDataGridsterGroup.setSize();
                    //指标卡规则触发
//                    if(abstractComponent instanceof AgileDataIndexComponent){
//                        AgileDataIndexComponent agileDataIndexComponent = (AgileDataIndexComponent) abstractComponent;
//                        size = agileDataIndexComponent.getGroup().size() + size;
//                    } else {
//                        size ++;
//                    }
                    if(triggerRule(12,agileDataGridsterArrange,area)){
                        AgileDataGridsterArrange newArrange = getNewAgileDataGridsterArrange(agileDataGridsterGroup,arranges);
                        agileDataGridsterArrange = newArrange;
                        isAdd = true;
                        continue;
                    }
                    agileDataGridsterArrange.getGroups().add(agileDataGridsterGroup);
                    agileDataGridsterArrange.setSize();
                    if(!isAdd) {
                        arranges.add(agileDataGridsterArrange);
                    }
                    isAdd = true;
                }
            }
        }
        //获取最大宽高
        reSize(arranges);
        //输出items结构
        arranges.stream().forEach(arrange -> arrange.getGroups().stream().forEach(group -> group.getAreas().stream().forEach(area -> {
            GridGroupDTO gridGroupDTO = new GridGroupDTO();
            gridGroupDTO.setId(area.getComponent().getId());
            gridGroupDTO.setType(area.getComponent().getType());
            gridGroupDTO.setX(area.getX());
            gridGroupDTO.setY(area.getY());
            gridGroupDTO.setCols(area.getCols());
            gridGroupDTO.setRows(area.getRows());
            gridGroupDTOList.add(gridGroupDTO);
        })));
        return gridGroupDTOList;
    }

    /**
     * 场景区域对象
     * @param components
     * @return
     */
    public static List<GridGroupDTO> createBoardItems(List<AbstractComponent> components,
                                                 BoardLayoutMongoData userDefineLayout) {
        List<GridGroupDTO> gridGroupDTOList = Lists.newArrayList();
        //获取所有组件
        if(CollectionUtils.isEmpty(components)) {
            return null;
        }
        //自定义特殊处理方式

        //生成行
        List<AgileDataGridsterArrange> arranges = Lists.newArrayList();
        //按组件顺序生成结构

        for(AbstractComponent component : components) {
            //生成行
            AgileDataGridsterArrange agileDataGridsterArrange = new AgileDataGridsterArrange();
            //区域初始化
            AgileDataGridsterArea area = new AgileDataGridsterArea(component,null);
            //是否存在自定义指标，存在则覆盖默认区域坐标
            GridGroupDTO userDefineGroup = getUserDefineGroup(userDefineLayout,component.getId());
            if(userDefineGroup != null){
                area.setSize(userDefineGroup.getCols(),userDefineGroup.getRows(),userDefineGroup.getX(),userDefineGroup.getY());
            } else {
                area.setSize();
            }
            //分组初始化
            AgileDataGridsterGroup agileDataGridsterGroup = new AgileDataGridsterGroup();
            agileDataGridsterGroup.getAreas().add(area);
            agileDataGridsterGroup.setSize();
            agileDataGridsterArrange.getGroups().add(agileDataGridsterGroup);
            agileDataGridsterArrange.setSize();
            arranges.add(agileDataGridsterArrange);
        }
        //获取最大宽高
        reSize(arranges);
        //输出items结构
        arranges.stream().forEach(arrange -> arrange.getGroups().stream().forEach(group -> group.getAreas().stream().forEach(area -> {
            GridGroupDTO gridGroupDTO = new GridGroupDTO();
            gridGroupDTO.setId(area.getComponent().getId());
            gridGroupDTO.setType(area.getComponent().getType());
            gridGroupDTO.setX(area.getX());
            gridGroupDTO.setY(area.getY());
            gridGroupDTO.setCols(area.getCols());
            gridGroupDTO.setRows(area.getRows());
            gridGroupDTOList.add(gridGroupDTO);
        })));
        return gridGroupDTOList;
    }

    public static List<GridGroupDTO> createUserDefineBoardItems(List<AbstractComponent> components,
                                                      BoardLayoutMongoData userDefineLayout) {
        List<GridGroupDTO> gridGroupDTOList = Lists.newArrayList();
        //获取所有组件
        if(CollectionUtils.isEmpty(components)) {
            return null;
        }
        int lastY = 0;
        //自定义特殊处理方式
        for(AbstractComponent component : components) {
            GridGroupDTO gridGroupDTO = new GridGroupDTO();
            gridGroupDTO.setId(component.getId());
            gridGroupDTO.setType(component.getType());
            //是否存在自定义指标，存在则覆盖默认区域坐标
            GridGroupDTO userDefineGroup = getUserDefineGroup(userDefineLayout,component.getId());
            if(userDefineGroup != null){
                gridGroupDTO.setX(userDefineGroup.getX());
                gridGroupDTO.setY(userDefineGroup.getY());
                gridGroupDTO.setCols(userDefineGroup.getCols());
                gridGroupDTO.setRows(userDefineGroup.getRows());
            } else {
                AgileDataGridsterArea area = new AgileDataGridsterArea(component,null);
                area.setSize();
                gridGroupDTO.setX(0);
                gridGroupDTO.setY(lastY);
                gridGroupDTO.setCols(area.getCols());
                gridGroupDTO.setRows(area.getRows());
            }
            lastY = gridGroupDTO.getY() + gridGroupDTO.getRows();
            gridGroupDTOList.add(gridGroupDTO);
        }
        return gridGroupDTOList;
    }

    /**
     * 查找自定义布局
     * @param userDefineLayout
     * @param defineId
     * @return
     */
    public static GridGroupDTO getUserDefineGroup(BoardLayoutMongoData userDefineLayout,String defineId){
        if(userDefineLayout == null){
            return null;
        }
        if(CollectionUtils.isEmpty(userDefineLayout.getBoardLayout())){
            return null;
        }
        return userDefineLayout.getBoardLayout().stream()
                .filter(gridGroup -> StringUtils.equals(gridGroup.getId(),defineId)).findFirst().orElse(null);
    }

    public static AgileDataGridsterArrange getNewAgileDataGridsterArrange(AgileDataGridsterGroup agileDataGridsterGroup,List<AgileDataGridsterArrange> arranges){
        AgileDataGridsterArrange newArrange = new AgileDataGridsterArrange();
        newArrange.getGroups().add(agileDataGridsterGroup);
        newArrange.setSize();
        arranges.add(newArrange);
        return newArrange;
    }

    public static List<GridGroupDTO> assembleGridster(List<AgileDataGridsterArrange> arranges){
        List<GridGroupDTO> gridGroupDTOList = Lists.newArrayList();
        arranges.stream().forEach(arrange -> arrange.getGroups().stream().forEach(group -> group.getAreas().stream().forEach(area -> {
            GridGroupDTO gridGroupDTO = new GridGroupDTO();
            gridGroupDTO.setId(area.getComponent().getId());
            gridGroupDTO.setType(area.getComponent().getType());
            gridGroupDTO.setX(area.getX());
            gridGroupDTO.setY(area.getY());
            gridGroupDTO.setCols(area.getCols());
            gridGroupDTO.setRows(area.getRows());
            gridGroupDTOList.add(gridGroupDTO);
        })));
        return gridGroupDTOList;
    }

    public static void reSize(List<AgileDataGridsterArrange> arranges){
        //获取最大宽高
        Optional<AgileDataGridsterArrange> arrangeOptional = arranges.stream().max(Comparator.comparing(AgileDataGridsterArrange::getWidth));
        if(arrangeOptional.isPresent()){
           AgileDataGridsterArrange maxArrange = arrangeOptional.get();
            //根据最大宽度，按比例适配最大宽度
//            arranges.stream().forEach(arrange -> arrange.reSize(maxArrange.getWidth()));
            //补齐宽度
//            arranges.stream().forEach(AgileDataGridsterArrange::completionSize);
            //计算坐标
            calcCoordinate(arranges);
        }
    }

    /**
     * 计算坐标
     * @param arranges
     */
    private static void calcCoordinate(List<AgileDataGridsterArrange> arranges) {
        //计算坐标
        int height = 0;
        for(AgileDataGridsterArrange arrange : arranges) {
            arrange.setCoordinate(height);
            height += arrange.getHeight();
        }
    }

    /**
     * 触发换行规则
     * @param num 阈值
     * @param agileDataGridsterArrange  当前行
     * @return
     */
    private static Boolean triggerRule(Integer num,AgileDataGridsterArrange agileDataGridsterArrange,AgileDataGridsterArea areaComponent){
        AtomicInteger totalCols = new AtomicInteger();
        agileDataGridsterArrange.getGroups().stream().forEach(group -> group.getAreas().stream().forEach(area -> totalCols.addAndGet(area.getCols())));

        //大于 阈值 ，生成新行
        if(totalCols.get() + areaComponent.getCols() > num){
            return true;
        }
        return false;
    }

    /**
     * AI布局算法
     * @param aiBoardLayout
     * @return
     */
    public static List<GridGroupDTO> createAILayout(AIBoardLayout aiBoardLayout) {
        List<GridGroupDTO> gridGroupDTOList = Lists.newArrayList();
        if(aiBoardLayout == null){
            return gridGroupDTOList;
        }
        if(CollectionUtils.isEmpty(aiBoardLayout.getCharts())){
            return gridGroupDTOList;
        }
        //遍历区域占比
        aiBoardLayout.getCharts().forEach(chart -> {
            //区域ID
            GridGroupDTO gridGroupDTO = new GridGroupDTO();
            //区域唯一标识
            gridGroupDTO.setId(String.valueOf(chart.getChartId()));
            //区域呈现类型
            gridGroupDTO.setType(chart.getShowType());
            //区域占比
            gridGroupDTO.setCols(chart.getDimensions().getAreaCols());
            gridGroupDTO.setRows(chart.getDimensions().getAreaRow());
            //区域坐标
            gridGroupDTO.setX(chart.getPosition().getLayoutCol().getStart());
            gridGroupDTO.setY(chart.getPosition().getLayoutRow().getStart());
            //标题
            gridGroupDTO.setTitle(chart.getTitle());
            gridGroupDTOList.add(gridGroupDTO);
        });
        return gridGroupDTOList;
    }

    /**
     * 获取主题映射布局
     * @param themeMapBoardDTO 看板内容
     * @param aiBoardLayout ai布局
     * @param userDefineLayout 用户自定义布局
     * @return
     */
    public static List<GridGroupDTO> createAIUserDefineLayout(ThemeMapBoardDTO themeMapBoardDTO,AIBoardLayout aiBoardLayout,
                                                              BoardLayoutMongoData userDefineLayout) {
        List<GridGroupDTO> gridGroupDTOList = Lists.newArrayList();
        if(themeMapBoardDTO == null){
            return gridGroupDTOList;
        }
        if(CollectionUtils.isEmpty(themeMapBoardDTO.getDataBoardQuestions())){
            return gridGroupDTOList;
        }
        if(aiBoardLayout == null){
            return gridGroupDTOList;
        }
        if(CollectionUtils.isEmpty(aiBoardLayout.getCharts())){
            return gridGroupDTOList;
        }
        //AI布局按布局ID和分组
        Map<String, AIBoardLayout.layoutArea> chartMap = aiBoardLayout.getCharts().stream()
                .filter(chart -> StringUtils.isNotBlank(chart.getChartId()))
                .collect(Collectors.toMap(AIBoardLayout.layoutArea::getChartId, chart -> chart, (exists, ignore) -> exists));
        //自定义布局按问题ID分组
        Map<String, GridGroupDTO> userLayoutMap = Optional.ofNullable(userDefineLayout)
                .map(BoardLayoutMongoData::getBoardLayout)
                .filter(CollectionUtils::isNotEmpty)
                .orElseGet(Lists::newArrayList)
                .stream()
                .filter(item -> StringUtils.isNotBlank(item.getId()))
                .collect(Collectors.toMap(GridGroupDTO::getId, item -> item, (exists, ignore) -> exists));
        //自定义布局最大纵坐标
        int fallbackRow = calculateFallbackRowStart(userLayoutMap.values());
        //替换布局ID
        for(ThemeMapBoardDTO.DataBoardQuestion dataBoardQuestion : themeMapBoardDTO.getDataBoardQuestions()){
            //获取数据看板问句ID
            Map<String,Object> dataParam = dataBoardQuestion.getDataParam();
            //获取看板的问句ID
            String questionId = MapUtils.getString(dataParam, "questionId", dataBoardQuestion.getQuestionId());
            //获取看板布局对应的自定义布局
            GridGroupDTO userGrid = userLayoutMap.get(dataBoardQuestion.getQuestionId());
            //获取看板布局对应的AI布局
            AIBoardLayout.layoutArea chart = chartMap.get(questionId);
            if(chart == null && !StringUtils.equals(questionId, dataBoardQuestion.getQuestionId())){
                chart = chartMap.get(dataBoardQuestion.getQuestionId());
            }
            GridGroupDTO gridGroupDTO = new GridGroupDTO();
            gridGroupDTO.setId(String.valueOf(dataBoardQuestion.getQuestionId()));
            String showType = resolveShowType(dataBoardQuestion, chart, userGrid);
            gridGroupDTO.setType(showType);
            if(userGrid != null){
                //用户自定义布局
                gridGroupDTO.setCols(userGrid.getCols());
                gridGroupDTO.setRows(userGrid.getRows());
                gridGroupDTO.setX(userGrid.getX());
                gridGroupDTO.setY(userGrid.getY());
                gridGroupDTO.setUserDefined(true);
                if(StringUtils.isNotBlank(userGrid.getTitle())){
                    gridGroupDTO.setTitle(userGrid.getTitle());
                }
            } else if(chart != null){
                //AI布局
                if(chart.getDimensions() != null){
                    gridGroupDTO.setCols(chart.getDimensions().getAreaCols());
                    gridGroupDTO.setRows(chart.getDimensions().getAreaRow());
                }
                if(chart.getPosition() != null && chart.getPosition().getLayoutCol() != null){
                    gridGroupDTO.setX(chart.getPosition().getLayoutCol().getStart());
                }
                if(chart.getPosition() != null && chart.getPosition().getLayoutRow() != null){
                    gridGroupDTO.setY(chart.getPosition().getLayoutRow().getStart());
                }
                if(StringUtils.isNotBlank(chart.getTitle())){
                    gridGroupDTO.setTitle(chart.getTitle());
                }
            } else {
                int defaultCols = resolveDefaultCols(showType);
                int defaultRows = resolveDefaultRows(showType);
                gridGroupDTO.setCols(defaultCols);
                gridGroupDTO.setRows(defaultRows);
                gridGroupDTO.setX(0);
                gridGroupDTO.setY(fallbackRow);
                fallbackRow += defaultRows;
                gridGroupDTO.setTitle(dataBoardQuestion.getQuestion());
            }
            if(gridGroupDTO.getTitle() == null){
                gridGroupDTO.setTitle(dataBoardQuestion.getQuestion());
            }
            gridGroupDTOList.add(gridGroupDTO);
        }
        return gridGroupDTOList;
    }

    private static int calculateFallbackRowStart(Collection<GridGroupDTO> layouts){
        if(CollectionUtils.isEmpty(layouts)){
            return 0;
        }
        return layouts.stream()
                .mapToInt(item -> safeValue(item.getY()) + safeValue(item.getRows()))
                .max()
                .orElse(0);
    }

    private static int safeValue(Integer value){
        return value == null ? 0 : value;
    }

    private static String resolveShowType(ThemeMapBoardDTO.DataBoardQuestion dataBoardQuestion,
                                          AIBoardLayout.layoutArea chart,
                                          GridGroupDTO userGrid){
        if(chart != null && StringUtils.isNotBlank(chart.getShowType())){
            return chart.getShowType();
        }
        if(userGrid != null && StringUtils.isNotBlank(userGrid.getType())){
            return userGrid.getType();
        }
        if(dataBoardQuestion.getShowType() != null){
            return String.valueOf(dataBoardQuestion.getShowType());
        }
        return null;
    }

    private static int resolveDefaultCols(String showType){
        if(StringUtils.equals("2", showType)){
            return 2;
        }
        if(StringUtils.equals("0", showType)){
            return 12;
        }
        return 6;
    }

    private static int resolveDefaultRows(String showType){
        if(StringUtils.equals("2", showType)){
            return 2;
        }
        return 6;
    }


}