package com.digiwin.athena.show.domain.agileDataDTO;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.show.component.DataAnalysisField;
import com.digiwin.athena.show.domain.queryDefine.PullDataDTO;
import com.digiwin.athena.show.infrastructure.meta.ECHOConstants;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataDataDTO;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.metadata.MetadataService;
import com.digiwin.athena.show.util.ApiMetadataUtil;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

public class ConvertGetAgileData {

    private ConvertGetAgileData() {
        throw new IllegalStateException("Utility class");
    }


    public static Map<String,MetadataField> getAgileData(String target,ApiMetadata apiMetadata){
        ApiMetadata masterApi = ConvertGetAgileData.getMasterMetadata(target,apiMetadata);
        ApiMetadataUtil.flatMetaData(masterApi);
        return ConvertGetAgileData.getFiledMap(target,masterApi);
    }

    /**
     * 获取业务数据
     * @param target
     * @param data
     * @return
     */
    public static List<Map<String,Object>> targetValue(String target,Object data){
        List<Map<String,Object>> dataList = Lists.newArrayList();
        Object obj = data;
        String[] paths = target.split(".");
        for(int i=0;i < paths.length;i++){
            if(obj instanceof Map) {
                Map<String,Object> bkMap = (Map<String, Object>) obj;
                obj = MapUtils.getObject(bkMap,paths[i]);
            } else if(obj instanceof Collection){
                List<Map<String,Object>> bkDataList = Lists.newArrayList();
                bkDataList.addAll( (List<Map<String, Object>>) obj);
                obj = bkDataList;
            }
        }
        if (obj instanceof Collection) {
            dataList.addAll((Collection<? extends Map<String, Object>>) obj);
        } else if (obj instanceof Map) {
            dataList.add((Map<String, Object>) obj);
        }
        return dataList;
    }

    public static ApiMetadata getMasterMetadata(String target, ApiMetadata apiMetadata){
        ApiMetadata masterMetadata;
        if(target.contains(".")){
            String[] targetArray = target.split("\\.");
            masterMetadata = ApiMetadataUtil.getApiMetadataByMetaName(targetArray[0],apiMetadata);
        } else {
            masterMetadata = ApiMetadataUtil.getApiMetadataByMetaName(target,apiMetadata);
        }
        return masterMetadata;
    }

    public static Map<String, MetadataField> getFiledMap(String target, ApiMetadata masterApi){
        Map<String,MetadataField> masterMetadataMap = masterApi.getResponseFieldMap();
        if(target.contains(".")){
            String[] targetArray = target.split("\\.");
            for(int i =0;i < targetArray.length;i++){
                MetadataField metadataField = masterMetadataMap.get(targetArray[i]);
                masterMetadataMap = metadataField.getFieldMap();
            }
        } else {
            MetadataField metadataField = masterMetadataMap.get(target);
            masterMetadataMap = metadataField.getFieldMap();
        }
        return masterMetadataMap;
    }

    public static List<MetadataField> getTargetFiled(String target,ApiMetadata masterApi){
        List<MetadataField> fieldList = Lists.newArrayList();
        Map<String,MetadataField> masterMetadataMap = masterApi.getResponseFieldMap();
        if(target.contains(".")){
            String[] targetArray = target.split("\\.");
            for(int i =0;i < targetArray.length;i++){
                MetadataField metadataField = masterMetadataMap.get(targetArray[i]);
                masterMetadataMap = metadataField.getFieldMap();
            }
            if(MapUtils.isNotEmpty(masterMetadataMap)) {
                fieldList.addAll(masterMetadataMap.values());
            }
        } else {
            MetadataField metadataField = masterMetadataMap.get(target);
            fieldList = metadataField.getSubFields();
        }
        return fieldList;
    }

    public static Map<String,MetadataField> getFiledMasterMap(String target,ApiMetadata masterApi){
        Map<String,MetadataField> result = masterApi.getResponseFieldMap();
        Map<String,MetadataField> masterMetadataMap = masterApi.getResponseFieldMap();
        if(target.contains(".")){
            String[] targetArray = target.split("\\.");
            for(int i =0;i < targetArray.length;i++){
                MetadataField metadataField = masterMetadataMap.get(targetArray[i]);
                if(metadataField != null &&
                        ECHOConstants.DataType.OBJECT.equals(metadataField.getDataType())){
                    result.put(metadataField.getName(),metadataField);
                    masterMetadataMap = metadataField.getFieldMap();
                }
            }
        }
        return result;
    }

    public static List<MetadataField> getFiledList(String target,ApiMetadata masterApi){
        List<MetadataField> filedList = Lists.newArrayList();

        if(target.contains(".")){
            MetadataField metadataField = null;
            String[] targetArray = target.split("\\.");
            for(int i =0;i < targetArray.length;i++){
                if(metadataField == null) {
                    metadataField = masterApi.getResponseFieldMap().get(targetArray[i]);
                    continue;
                }
                metadataField = metadataField.getFieldMap().get(targetArray[i]);
            }
            filedList.add(metadataField);
        } else {
            filedList = masterApi.getResponseFields();
        }
        return filedList;
    }

    /**
     * 获取指定类型字段
     * @param target
     * @param apiMetadata
     * @param contains 是否满足 true满足，false不满足
     * @return
     */
    public static List<MetadataField> getStringField(String type,String target,ApiMetadata apiMetadata,Boolean contains){
        List<MetadataField> stringMetadataFields = Lists.newArrayList();
        if(apiMetadata == null){
            return stringMetadataFields;
        }
        ApiMetadataUtil.flatMetaData(apiMetadata);
        List<MetadataField> metadataFields = ConvertGetAgileData.getTargetFiled(target,apiMetadata);
        if(CollectionUtils.isNotEmpty(metadataFields)){
            metadataFields.stream().forEach(metadataField -> {
                if(contains){
                    if(StringUtils.equals(type,metadataField.getDataType())){
                        stringMetadataFields.add(metadataField);
                    }
                } else {
                    if(!StringUtils.equals(type,metadataField.getDataType())){
                        stringMetadataFields.add(metadataField);
                    }
                }

            });
        }
        return stringMetadataFields;
    }

    /**
     * 生成维度/度量字段
     * @param type 0：维度 1：度量
     * @param measurementField
     * @param dataMap
     * @return
     */
    public static List<DataAnalysisField> getOriginalField(Integer type,MetadataField measurementField,MetadataField dimensionField,Map<String,Object> dataMap){
        List<DataAnalysisField> metadataFields = Lists.newArrayList();
        //获取维度信息
        if(0 == type && dimensionField != null){
            DataAnalysisField metric = new DataAnalysisField();
            metric.setName(dimensionField.getDescription());
            metric.setDataKey(dimensionField.getName());
            metadataFields.add(metric);
        }
        //从拼接字段中获取维度/度量信息
        if(CollectionUtils.isNotEmpty(measurementField.getOriginalFields())) {
            List<MetadataField> analysisData;
            if(0 == type){
                analysisData = measurementField.getOriginalFields().stream()
                        .filter(originalField -> !StringUtils.equals("numeric", originalField.getDataType())).collect(Collectors.toList());
            } else {
                analysisData = measurementField.getOriginalFields().stream()
                        .filter(originalField -> StringUtils.equals("numeric", originalField.getDataType())).collect(Collectors.toList());
            }
            if (CollectionUtils.isNotEmpty(analysisData)) {
                metadataFields.addAll(analysisData.stream().map(field -> {
                    DataAnalysisField dataAnalysisField = new DataAnalysisField();
                    dataAnalysisField.setName(field.getDescription());
                    dataAnalysisField.setDataKey(field.getName());
                    if(Objects.isNull(field.getOriginalData())) {
                        dataAnalysisField.setValue(dataMap.get(field.getName()));
                    } else {
                        dataAnalysisField.setValue(field.getOriginalData());
                    }
                    return dataAnalysisField;
                }).collect(Collectors.toList()));
            }
        } else {
            //非拼接字段获取当前度量信息
            if(1 == type) {
                DataAnalysisField metric = new DataAnalysisField();
                metric.setName(measurementField.getDescription());
                metric.setDataKey(measurementField.getName());
                if (Objects.isNull(measurementField.getOriginalData())) {
                    metric.setValue(dataMap.get(measurementField.getName()));
                } else {
                    metric.setValue(measurementField.getOriginalData());
                }
                metadataFields.add(metric);
            }
        }
        return metadataFields;
    }

    /**
     * 从元数据中获取字段信息，若字段不存在，则进行模糊匹配
     * @param target
     * @param apiMetadata
     * @param field
     * @return
     */
    public static String getApiFiled(String target,ApiMetadata apiMetadata,String field){
        String findField = "";
        //获取到元数据业务字段信息
        ApiMetadataUtil.flatMetaData(apiMetadata);
        List<MetadataField> metadataFields = getTargetFiled(target,apiMetadata);
        //匹配字段是否存在
        Optional<MetadataField> optFindField = metadataFields.stream().filter(metadataField -> StringUtils.equals(field,metadataField.getName())).findFirst();
        //不存在，则进行模糊匹配，使用元数据字段
        if(!optFindField.isPresent()){
            for(MetadataField metadataField : metadataFields) {
                if(field.contains(metadataField.getName())){
                    findField = metadataField.getName();
                }
            }
        } else {
            findField = field;
        }
        return findField;
    }

    public static String getRootFiled(ApiMetadata apiMetadata){
        String findField = "";
        //获取到元数据业务字段信息
        List<MetadataField> metadataFields = apiMetadata.getResponseFields();
        if(CollectionUtils.isNotEmpty(metadataFields)){
            for(MetadataField metadataField : metadataFields){
                if(metadataField.isObjectField()){
                    findField = metadataField.getName();
                    break;
                }
            }
        }
        return findField;
    }

    public static MetadataField getRootMetadataField(ApiMetadata apiMetadata){
        MetadataField objectMetadataField = new MetadataField();
        //获取到元数据业务字段信息
        List<MetadataField> metadataFields = apiMetadata.getResponseFields();
        if(CollectionUtils.isNotEmpty(metadataFields)){
            for(MetadataField metadataField : metadataFields){
                if(metadataField.isObjectField()){
                    objectMetadataField = metadataField;
                    break;
                }
            }
        }
        return objectMetadataField;
    }

    /**
     * 转换元数据结构
     * @param metadata
     * @return
     */
    public static ApiMetadata transPullData(Map<String,Object> metadata,String actionId){
        ApiMetadata apiMetadata = null;
        MetadataDataDTO metadataDataDTO = null;
        //获取元数据生成结果
        if (MapUtils.isNotEmpty(metadata)) {
            metadataDataDTO = JsonUtils.jsonToObject(JsonUtils.objectToString(metadata), MetadataDataDTO.class);
        }
        //转换为元数据结构
        if (metadataDataDTO != null) {
            apiMetadata = SpringUtil.getBean(MetadataService.class).createApiMetadata(metadataDataDTO);
                apiMetadata.setActionId(actionId);
        }
        return apiMetadata;
    }

    /**
     * 获取业务数据
     * @param pullData
     * @return
     */
    public static List<Map<String,Object>> trnasData(Map<String,Object> pullData){
        List<Map<String,Object>> datas = Lists.newArrayList();
        if(MapUtils.isEmpty(pullData)){
            return datas;
        }
        Object agileDataObj = pullData.get("data");
        List<Map<String,Object>> agileData = Lists.newArrayList();
        if(agileDataObj instanceof List){
            agileData = (List<Map<String,Object>>) agileDataObj;
        } else {
            agileData.add((Map<String,Object>) agileDataObj);
        }
        if(CollectionUtils.isEmpty(agileData)){
            return datas;
        }
        datas = agileData;

        return datas;
    }




}
