package com.digiwin.athena.show.domain.analysis;

import com.digiwin.athena.show.component.ComponentFormat;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 归因分析-维度分析数据呈现结构
 */
@Data
public class AnalysisDataDimensionDTO {

    /**
     * 数据执行结果
     */
    private Boolean dataResult;

    /**
     * 数据执行结果信息
     */
    private String message;

    /**
     * 汇总数据
     */
    private List<AnalysisDataAscribe> ascribe;

    @Data
    public static class AnalysisDataAscribe {
        //页签名称
        private String dimensionName;
        //正向进度条
        private List<AnalysisDataProgress> forward;
        //负向进度条
        private List<AnalysisDataProgress> reverse;
    }

    @Data
    public static class AnalysisDataProgress {
        //维度名称
        private AnalysisDataDimensionData description;
        //维度值
        private AnalysisDataDimensionData fieldValue;
        //占比值
        private AnalysisDataDimensionData account;

    }

    @Data
    public static class AnalysisDataDimensionData {
        //数据值
        private Object value;
        //格式化信息
        private ComponentFormat format;
    }

}
