package com.digiwin.athena.show.domain.analysis;

import com.digiwin.athena.show.component.ComponentFormat;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 归因分析-数据汇总呈现结构
 */
@Data
public class AnalysisDataSummaryDTO {

    /**
     * 数据执行结果
     */
    private Boolean dataResult;

    /**
     * 数据执行结果信息
     */
    private String message;

    /**
     * 汇总数据
     */
    private List<AnalysisDataFluctuate> fluctuateData;

    /**
     * 归因分析入参
     */
    private Map<String,Object> analysisParams;

    @Data
    public static class AnalysisDataFluctuate {
        //指标卡标题
        private String description;
        //指标卡值
        private Object value;
        //转换结构
        private ComponentFormat format;
    }

}
