package com.digiwin.athena.show.domain.analysis;

import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class AnalysisFluctuateReq {

    /**
     * 快照ID
     */
    private String snapshotId;

    /**
     * 语义分析过程信息
     */
    private Map<String,Object> processStreamData;

    /**
     * 用户筛选维度条件
     */
    private List<AnalysisMetric> dimensionData;

    /**
     * 用户筛选度量条件
     */
    private List<AnalysisMetric> measurementData;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * AI输出结果SQL
     */
    private Map<String,Object> orgOutPutSql;

    /**
     * 分析参数
     */
    private Map<String,Object> analysisParams;


}
