package com.digiwin.athena.show.domain.showDefine;

import com.digiwin.athena.show.domain.agileDataDTO.*;
import com.digiwin.athena.show.metadata.ApiMetadata;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 敏捷报表定义
 */
@Data
public class ThemeMapReport {

    /**
     * 请求数据标识
     */
    private String actionId;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 轮播时间
     */
    private Integer pageTurningFrequency;

    /**
     * 客户端0.PC 1.移动
     */
    private Integer client;

    /**
     * 报表标题
     */
    private String title;

    /**
     * 报表明细code
     */
    private String code;

    /**
     * 展现形式0.table1.ecahrts
     */
    private Integer reportShow;

    /**
     * 原始类型
     */
    private Integer sourceReportShow;

    /**
     * 数据源名称
     */
    private String dataSourceName;

    /**
     * echarts图表定义
     */
    private AgileReportECharts eCharts;

    /**
     * 是否开启分页
     */
    private Boolean enablePaging;

    /**
     * 元数据
     */
    private ApiMetadata apiMetadata;

    /**
     * 业务数据标签
     */
    private AgileDataTag agileDataTag;

    /**
     * 业务数据
     */
    private List<Map<String,Object>> pageData;


    /**
     * 敏捷规则
     */
    private List<AgileReportRuleDTO> agileRule;

    /**
     * 敏捷指标
     */
    private AgileReportIndex agileReportIndex;

    /**
     * 卡片定义
     */
    private AgileReportCard card;

    /**
     * 数据源
     */
    private String dataSource;

    /**
     * 数据流关系
     */
    private List<AgileDataRelationDTO> agileDataRelation;




}
