package com.digiwin.athena.show.manager.themeMap;

import com.digiwin.athena.show.domain.agileDataDTO.AgileDataRelationDTO;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.manager.themeMap.domain.ThemeMapBoardDTO;

import java.util.List;
import java.util.Map;

public interface ThemeAgileDataService {

    /**
     * 获取场景图谱信息
     * @param code
     * @return
     */
    AgileReportKMData querySceneMaps(String code);

    /**
     * 获取图谱关系
     * @param actionIds
     * @return
     */
    List<AgileDataRelationDTO> queryActionRelation(List<String> actionIds);

    /**
     * 批量查询数据图谱
     * @param actionIds
     * @return
     */
    List<AgileReportKMData> querySceneMapsByActionId(List<String> actionIds);

    /**
     * 敏捷数据呈现图谱
     * @param chartParams
     * @return
     */
    String findLastNodeShapeType(Map<String,Object> chartParams);

    /**
     * 查看看板信息
     * @param boardId
     * @return
     */
    ThemeMapBoardDTO getThemeMapBoard(String boardId);

    /**
     * 查看看板收藏问题信息
     * @param questionId
     * @return
     */
    ThemeMapBoardDTO.DataBoardQuestion getThemeMapBoardQuestion(String questionId);

}
