package com.digiwin.athena.show.metadata;

import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.*;

/**
 * @description: API元数据
 * @create: 2020-05-14 11:25
 **/
@Data
public class ApiMetadata implements Serializable {


    /**
     * 元数据ID
     */
    private String actionId;

    /**
     * 元数据名称
     */
    private String serviceName;

    /**
     * request 字段集合
     */
    private List<MetadataField> requestFields;


    /**
     * 把子节点变成带路径的结构
     */
    private Map<String, MetadataField> requestFieldMap = new HashMap<>();


    /**
     * response 字段集合
     */
    private List<MetadataField> responseFields;

    /**
     * 呈现图形查询一级参数
     */
    private String sceneNodeType;

    /**
     * 呈现类型0.表 1.图 2.指标
     */
    private String showType;

    /**
     * 元数据名称
     */
    private String name;


    /**
     * 把子节点变成带路径的结构
     */
    private Map<String, MetadataField> responseFieldMap = new LinkedHashMap<>();


    public void addResponseFields(List<MetadataField> fields) {
        if (this.responseFields == null) {
            this.responseFields = new ArrayList<>();
        }
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        if (this.responseFields.isEmpty()) {
            this.responseFields.addAll(fields);
        } else {
            if (this.responseFields.get(0).getSubFields() == null) {
                this.responseFields.get(0).setSubFields(new ArrayList<>());
            }
            Set<String> allFields = new HashSet<>();
            for (MetadataField subField : this.responseFields.get(0).getSubFields()) {
                allFields.add(subField.getName());
            }
            for (MetadataField field : fields) {
                if (!allFields.contains(field.getName())) {
                    this.responseFields.get(0).getSubFields().add(field);
                } else {
                    //已经存在的，替换掉，因为指定元数据目的应该有2个：增加缺少的和替换
                    Optional<MetadataField> existFieldOptional = this.responseFields.get(0).getSubFields().stream().filter(x -> Objects.equals(x.getName(), field.getName())).findFirst();
                    if (existFieldOptional.isPresent()) {
                        MetadataField existFiled = existFieldOptional.get();
                        List<MetadataField> subFields = existFiled.getSubFields();
                        List<MetadataField> sourceSubFields = field.getSubFields();
                        if(CollectionUtils.isEmpty(subFields)){
                            // 原有逻辑
                            this.responseFields.get(0).getSubFields().remove(existFiled);
                            this.responseFields.get(0).getSubFields().add(field);
                        }else {
                            // 如果虚拟字段有单身
                          if(CollectionUtils.isNotEmpty(sourceSubFields)){
                              mergeMetadataField(sourceSubFields,subFields);
                          }
                        }
                    }
                }
            }
        }
    }

    /**
     * 合并字段，如
     * [{name:"1",subFields:[{name:"1-1",remark:"111"},{name:"1-3"}]},{name:"2"},{name:"4",subFields:[{name:5}]}]
     * [{name:"1",subFields:[{name:"1-1"},{name:"1-4"}]},{name:"3"},{name:"4",subFields:[]}]
     * 转换为[{name:"1",subFields:[{name:"1-4"},{name:"1-1",remark:"111"},{name:"1-3"}]},{name:"3"},{name:"4",subFields:[{name:5}]}]
     * @param sourceFields 虚拟字段
     * @param targetFields 目标字段
     */
    private void mergeMetadataField(List<MetadataField> sourceFields, List<MetadataField> targetFields){
        // 遍历虚拟字段
        Iterator<MetadataField> iterator = sourceFields.iterator();
        while (iterator.hasNext()){
            MetadataField next = iterator.next();
            String name = next.getName();
            List<MetadataField> subFields = next.getSubFields();
            // 用来标记相同名称的目标字段位置
            int index = -1;
            for (int i = 0; i < targetFields.size(); i++) {
                MetadataField metadataField = targetFields.get(i);
                if(Objects.equals(metadataField.getName(),name)){
                    index = i;
                }
            }
            // 有相同值
            if(index>-1){
                MetadataField metadataField = targetFields.get(index);
                List<MetadataField> subTargetFields = metadataField.getSubFields();
                // 如果目标字段有单身
                if(CollectionUtils.isNotEmpty(subTargetFields)){
                    // 移除虚拟字段，不进行合并
                    iterator.remove();
                    // 如果虚拟字段含有单身，递归处理子层级
                    if(CollectionUtils.isNotEmpty(subFields)){
                        mergeMetadataField(subFields,subTargetFields);
                    }
                }else {
                    // 没有单身，直接用虚拟字段的信息
                    targetFields.remove(index);
                }
            }
        }
        // 将虚拟字段合入目标字段
        if(CollectionUtils.isNotEmpty(sourceFields)){
            targetFields.addAll(sourceFields);
        }
    }

}
