package com.digiwin.athena.show.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MetadataFieldDTO {

    private String data_name;

    private Boolean required;

    private String description;

    private String remark;

    private String api;

    private String is_datakey;

    @JsonProperty("is_businesskey")
    private boolean is_businesskey;

    private String data_type;

    private String precision;

    @JsonProperty("is_array")
    private boolean is_array;

    private String enum_key;

    private List<MetadataFieldDTO> field;

    /**
     * 是否可排序
     */
    private Boolean can_sort;

    /**
     * 排序值
     */
    private String sort;

    /**
     * 是否可筛选
     */
    private Boolean can_filter;

    /**
     * 是否展示百分比/千分位
     */
    private String percent;

    /**
     * 保留小数位
     */
    private Integer decimal;

    /**
     * 单头，原始数据
     */
    private List<MetadataFieldDTO> originalFields;

    /**
     * 单头，原始数据
     */
    private Object originalData;

}
