package com.digiwin.athena.show.service;

import com.digiwin.athena.show.domain.analysis.AnalysisDataDimensionDTO;
import com.digiwin.athena.show.domain.analysis.AnalysisDataSummaryDTO;
import com.digiwin.athena.show.domain.analysis.AnalysisFluctuateReq;

/**
 * 归因分析
 */
public interface AgileDataAnalysisService {

    /**
     * 获取归因分析数据
     *
     * @param analysisFluctuateReq
     * @param local
     * @return
     */
    AnalysisDataSummaryDTO getAnalysisDataSummary(AnalysisFluctuateReq analysisFluctuateReq, String local);

    /**
     * 获取归因分析数据维度
     *
     * @param analysisFluctuateReq
     * @param local
     * @return
     */
    AnalysisDataDimensionDTO getAnalysisDataDimension(AnalysisFluctuateReq analysisFluctuateReq, String local);

}
