package com.digiwin.athena.show.service;

import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.TargetDTO;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.metadata.ApiMetadata;

import java.util.List;
import java.util.Map;

public abstract class AgileDataThemeMapDefine {

    protected final String SUPPORT_KEY_PREFIX = "AGILE_DATA_DEFINE_";

    public abstract String supportKey();

    /**
     * 大屏用户级定义
     * @param agileReportKMData
     * @param executeContext
     */
    public abstract void buildScreenModel(AgileReportKMData agileReportKMData, ExecuteContext executeContext);

    /**
     * 数据校验
     * @param judgeCode
     * @param executeContext
     * @param apiMetadata
     * @param agileDataListList
     * @param targetDTO
     * @param pageData
     * @return
     */
    public abstract Boolean judgeDefine(String judgeCode, ExecuteContext executeContext, ApiMetadata apiMetadata, List<Map<String, Object>> agileDataListList, TargetDTO targetDTO, List<Map<String, Object>> pageData);

}
