package com.digiwin.athena.show.service;

import com.digiwin.athena.agiledataecho.domain.AgileDataStandardReq;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.AgileDataStandardShow;
import com.digiwin.athena.show.domain.showDefine.DynamicAgileData;

import java.util.List;

public interface AgileReportService {

    /**
     * 生成敏捷报表交互界面
     * @param executeContext
     * @return
     */
    DynamicAgileData createAgileReportTemplateTable(ExecuteContext executeContext, SnapDataDTO snapDataDTO);

    /**
     * 呈现类型
     * @param dynamicAgileData
     * @param defaultShowType
     * @return
     */
    String getShowType(DynamicAgileData dynamicAgileData,String defaultShowType);

    /**
     * 输出标准呈现结构
     * @param agileDataStandardReq
     * @return
     */
    AgileDataStandardShow getAgileDataStandardShow(AgileDataStandardReq agileDataStandardReq);

}
