package com.digiwin.athena.show.service;

import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.dto.EchoInformationReqDTO;
import com.digiwin.athena.agiledataecho.service.EchoInformationService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.*;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.util.layout.AgileDataCheck;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 图表呈现定义
 */
@Slf4j
@Service
public abstract class CompletionEchartsDefine {

    @Autowired
    private EchoInformationService echoInformationService;

    @Autowired
    private MessageUtils messageUtils;

    private static final String AGILE_DATA_DESCRIPTION = "缺少%s字段设定，无法呈现图形";

    private static final String AGILE_DATA_CONTENT = "当前取得的各个字段的中英文名称及其对应%s";

    private static final String AGILE_DATA_EXTEND = "图形需维度度量至少各有一个，指标卡需至少一个度量，才可呈现，请修改字段对应维度/度量，或者增加新的维度/度量字段";

    public abstract String supportKey();

    public void completionEchartsDefine(AgileReportShow showInfo, AgileReportKMData agileReportKMData,
                                        ApiMetadata apiMetadata, ExecuteContext executeContext,
                                        Integer dimensionRelationShip,AgileReportRuleDTO agileReportRuleDTO) {
        //补全图形配置
        if (CollectionUtils.isEmpty(showInfo.getEChart())) {

            List<AgileReportEChartDefineDTO> eChartDefineDTOList = Lists.newArrayList();
            //维度，取第一个string字段
            List<MetadataField> xaxisMetadataFields = ConvertGetAgileData.getStringField("numeric", showInfo.getTargetSource(), apiMetadata, false);
            if (CollectionUtils.isEmpty(xaxisMetadataFields)) {
                if(!AgileDataCheck.isScreen(executeContext)) {
                    EchoInformationReqDTO echoInformationReqDTO = new EchoInformationReqDTO();
                    echoInformationReqDTO.setMessageId(Long.valueOf(executeContext.getMessageId()));
                    echoInformationReqDTO.setDescription(String.format(AGILE_DATA_DESCRIPTION, "维度"));
                    echoInformationReqDTO.setContent(String.format(AGILE_DATA_CONTENT, "维度"));
                    echoInformationReqDTO.setExtend(AGILE_DATA_EXTEND);
                    echoInformationService.submit(echoInformationReqDTO, executeContext.getAuthoredUser());
                    agileReportKMData.getShow().remove(showInfo);
                    throw BusinessException.create(ErrorCodeEnum.AGILE_REPORT_DATA_ERROR.getErrCode(),messageUtils.getMessage("exception.agileReport.chat.empty.data"));
                }
                return;
            }
            //获取维度信息
            List<AgileReportDataFindDTO> xAxis = getXAxis(xaxisMetadataFields,dimensionRelationShip);

            List<MetadataField> seriesMetadataFields = ConvertGetAgileData.getStringField("numeric", showInfo.getTargetSource(), apiMetadata, true);
            if (CollectionUtils.isEmpty(seriesMetadataFields)) {
                //非大屏需上报异常
                if(!AgileDataCheck.isScreen(executeContext)) {
                    EchoInformationReqDTO echoInformationReqDTO = new EchoInformationReqDTO();
                    echoInformationReqDTO.setMessageId(Long.valueOf(executeContext.getMessageId()));
                    echoInformationReqDTO.setDescription(String.format(AGILE_DATA_DESCRIPTION, "度量"));
                    echoInformationReqDTO.setContent(String.format(AGILE_DATA_CONTENT, "度量"));
                    echoInformationReqDTO.setExtend(AGILE_DATA_EXTEND);
                    echoInformationService.submit(echoInformationReqDTO, executeContext.getAuthoredUser());
                    agileReportKMData.getShow().remove(showInfo);
                    throw BusinessException.create(ErrorCodeEnum.AGILE_REPORT_DATA_ERROR.getErrCode(),messageUtils.getMessage("exception.agileReport.chat.empty.data"));
                }
                return;
            }
            getEcharts(seriesMetadataFields,agileReportRuleDTO,apiMetadata,showInfo,xAxis,eChartDefineDTOList);
            showInfo.setEChart(eChartDefineDTOList);
        }
    }

    /**
     * 获取维度信息
     * @param xAxisMetadataFields
     * @return
     */
    protected abstract List<AgileReportDataFindDTO> getXAxis(List<MetadataField> xAxisMetadataFields,Integer dimensionRelationShip);

    /**
     * 获取度量信息
     * @param yAxisMetadataFields
     * @param agileReportRuleDTO
     * @param apiMetadata
     * @return
     */
    protected abstract void getEcharts(List<MetadataField> yAxisMetadataFields,AgileReportRuleDTO agileReportRuleDTO,
                                       ApiMetadata apiMetadata,AgileReportShow showInfo, List<AgileReportDataFindDTO> xAxis,
                                       List<AgileReportEChartDefineDTO> eChartDefineDTOList);


}
