package com.digiwin.athena.show.service.impl;


import com.digiwin.athena.show.assistant.AgileReportShowTypeEnum;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.labelTitle.LabelTitleComponentImpl;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataRelationDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReport;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileDataBusinessProcess;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@Service
public class AgileDataBusinessProcessImpl implements AgileDataBusinessProcess {

    @Autowired
    private LabelTitleComponentImpl labelTitleComponent;


    /**
     * 组装为formlayout结构，且根据组装结果变更数据集
     * @param components
     * @param executeContext
     * @param components
     * @return
     */
    @Override
    public List<AbstractComponent> process(List<AgileDataRelationDTO> agileDataRelationDTOList, ExecuteContext executeContext,
                                           List<AbstractComponent> components, AgileReport agileReport) {
        List<AbstractComponent> abstractComponents = components;
        if(CollectionUtils.isNotEmpty(components)){
            //数据流按schema及path进行分组
            Map<String, List<AbstractComponent>> abstractComponentsMap = this.getAbstractComponentsMap(components);
            //设置标题，同时更改数据结构
            List<AbstractComponent> abstractComponentList = this.createTitleComponents(executeContext,abstractComponentsMap,agileReport);
            if(CollectionUtils.isNotEmpty(abstractComponentList)){
                abstractComponents = abstractComponentList;
                //呈现组件绑定关系
                this.bindShowBest(agileDataRelationDTOList,abstractComponentsMap,agileReport);
            }
        }
        return abstractComponents;
    }


    private void bindShowBest(List<AgileDataRelationDTO> agileDataRelationDTOList,Map<String, List<AbstractComponent>> abstractComponentsMap
            ,AgileReport agileReport){
        abstractComponentsMap.forEach((k,v) -> {
            String actionId = StringUtils.EMPTY;
            String type = StringUtils.EMPTY;
            //获取actionId
            ThemeMapReport themeMapReport = agileReport.getReport().stream().filter(report -> StringUtils.equals(k,report.getDataSource())).findFirst().orElse(null);
            if(themeMapReport != null){
                String agileDataShow = themeMapReport.getReportShow().toString();
                type = AgileReportShowTypeEnum.getType(agileDataShow);
                actionId = themeMapReport.getActionId();
            }

            //绑定到呈现关系中
            this.bindComponentId(agileDataRelationDTOList,actionId,v,type);
        });
    }

    /**
     * 绑定组件id
     * @param agileDataRelationDTOList
     * @param actionId
     * @param componentList
     * @param type
     */
    private void bindComponentId(List<AgileDataRelationDTO> agileDataRelationDTOList, String actionId, List<AbstractComponent> componentList, String type){
        if(CollectionUtils.isNotEmpty(agileDataRelationDTOList)){
            agileDataRelationDTOList.stream().forEach(relation -> {
                if(StringUtils.equals(actionId,relation.getActionId())){
                    relation.setType(type);
                    if(CollectionUtils.isNotEmpty(relation.getAbstractComponents())){
                        relation.getAbstractComponents().addAll(componentList);
                    }else {
                        relation.setAbstractComponents(componentList);
                    }
                }
                if(CollectionUtils.isNotEmpty(relation.getSubAction())){
                    this.bindComponentId(relation.getSubAction(),actionId,componentList,type);
                }
            });
        }
    }

    /**
     * 按数据流分组
     * @param components
     * @return
     */
    private Map<String, List<AbstractComponent>> getAbstractComponentsMap(List<AbstractComponent> components){
        Map<String, List<AbstractComponent>> abstractComponentsMap = Maps.newHashMap();
        components.stream().forEach(component -> {
            if(component.getId() != null){
                //按id分组
                if(abstractComponentsMap.containsKey(component.getId())){
                    abstractComponentsMap.get(component.getId()).add(component);
                    return;
                }
                List<AbstractComponent> componentList = Lists.newArrayList();
                componentList.add(component);
                abstractComponentsMap.put(component.getId(),componentList);
            }
        });
        return abstractComponentsMap;
    }



    /**
     * 生成标题label
     * @param abstractComponentsMap
     * @return
     */
    private List<AbstractComponent> createTitleComponents(ExecuteContext executeContext,Map<String, List<AbstractComponent>> abstractComponentsMap,AgileReport agileReport){
        if(StringUtils.isNotEmpty(executeContext.getEntry())){
            if(!StringUtils.equals("0",executeContext.getEntry())){
               return abstractComponentsMap.values().stream()
                       .flatMap(List::stream)
                       .collect(Collectors.toList());
            }
        }
        List<AbstractComponent> abstractComponents = Lists.newArrayList();
        abstractComponentsMap.forEach((k,v) -> {
            List<AbstractComponent> components = Lists.newArrayList();
            ThemeMapReport themeMapReport =
                    agileReport.getReport().stream().filter(report -> report.getDataSource().equals(k)).findFirst().get();
            String labelSchema = "agileData_label_";
            AtomicInteger pageNum = new AtomicInteger();
            //标题组件
            AbstractComponent labelComponent = labelTitleComponent.initComponent(new MetadataField(), new BuildContext());
//            abstractComponents.add(labelComponent);
            components.add(labelComponent);
            labelComponent.setId(labelSchema + pageNum);
            labelComponent.setId(themeMapReport.getActionId());
            v.stream().forEach(component -> {
                if(StringUtils.isNotEmpty(component.getTitle())) {
                    component.setTitle("");
                }
                abstractComponents.add(component);
                components.add(component);
            });
            v.clear();
            v.addAll(components);
            //设置标题数据结构
//            agileDataPageDataService.assemblePageData(k,labelComponent.getSchema(), pageDefines, fromLayout);
            pageNum.getAndIncrement();
        });
        return abstractComponents;
    }
}
