package com.digiwin.athena.show.service.impl;


import com.digiwin.athena.agiledataecho.domain.SceneSelectInfo;
import com.digiwin.athena.agiledataecho.service.MoreActionUserSelectService;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.AbstractComponentBody;
import com.digiwin.athena.show.component.AbstractComponentField;
import com.digiwin.athena.show.component.AbstractComponentHeader;
import com.digiwin.athena.show.component.card.*;
import com.digiwin.athena.show.component.list.ListComponent;
import com.digiwin.athena.show.component.list.ListComponentImpl;
import com.digiwin.athena.show.component.multipleSelect.MultipleSelectComponentImpl;
import com.digiwin.athena.show.component.panel.PanelComponent;
import com.digiwin.athena.show.component.panel.PanelComponentImpl;
import com.digiwin.athena.show.component.progressBar.ProgressBarComponent;
import com.digiwin.athena.show.component.progressBar.ProgressBarComponentImpl;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.domain.agileDataDTO.*;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileDataCardInterpreter;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 敏捷数据卡组件解释器
 */
@Service
public class AgileDataCardInterpreterImpl implements AgileDataCardInterpreter {


    @Autowired
    private PanelComponentImpl panelComponentImpl;

    @Autowired
    private MultipleSelectComponentImpl multipleSelectComponent;

    @Autowired
    private ProgressBarComponentImpl progressBarComponentImpl;

    @Autowired
    private CardComponentImpl cardComponentImpl;

    @Autowired
    private ListComponentImpl listComponentImpl;

    @Autowired
    private MoreActionUserSelectService moreActionUserSelectService;

    /**
     * 生成卡片组件
     *
     * @param themeMapReport
     * @param buildContext
     */
    @Override
    public AbstractComponent interpreter(ThemeMapReport themeMapReport, BuildContext buildContext) {
        if (themeMapReport != null) {
            AgileReportCard agileReportCard = themeMapReport.getCard();
            if (agileReportCard.getCardDefine() == null) {
                return null;
            }
            //构建进度条
            ProgressBarComponent progressBarComponent = this.createProgressBar(themeMapReport, buildContext);
            //构建卡片
            CardComponent cardComponent = this.createCard(themeMapReport, progressBarComponent, buildContext);
            //默认通过列表组件包装
            List<AbstractComponent> components = Lists.newArrayList();
            components.add(cardComponent);
            ListComponent listComponent = this.createList(themeMapReport, components, buildContext);
            //是否需要构建白板
            components = Lists.newArrayList();
            components.add(listComponent);
            PanelComponent panelComponent = createPanel(themeMapReport, components, buildContext);
            if (panelComponent == null) {
                return listComponent;
            }
            return panelComponent;
        }
        return null;
    }

    /**
     * 根据父节点设置pageData结构
     *
     * @param panelComponent
     * @param userSelectInfo
     * @param themeMapReport
     */
    private void setPanelPageData(PanelComponent panelComponent, List<String> userSelectInfo, ThemeMapReport themeMapReport) {
        Map<String, Object> pageData = Maps.newHashMap();

        //TODO 大屏类如何设置下拉数据结构，待前端支持后讨论
        //业务数据
//        Object pageObject = dynamicForm.getPageData().get(reportConditionPageDefine.getAgileDataDefine().getTargetSource());
//        //构建header结构
//        panelComponent.getHeader().getGroup().stream().forEach(group -> {
//            if (StringUtils.equals("SELECT_MULTIPLE", group.getType())) {
//                pageData.put(group.getSchema(), CollectionUtils.isNotEmpty(userSelectInfo) ? userSelectInfo : Lists.newArrayList());
//            }
//        });
//        panelComponent.getBody().getGroup().stream().forEach(group -> pageData.put(group.getSchema(), pageObject));
//        themeMapReport.getPageData().put(reportConditionPageDefine.getAgileDataDefine().getTargetSource(), pageData);
    }


    /**
     * 构建列表
     *
     * @param themeMapReport
     * @param components
     * @param buildContext
     * @return
     */
    private ListComponent createList(ThemeMapReport themeMapReport, List<AbstractComponent> components, BuildContext buildContext) {
        //元数据结构
        ApiMetadata apiMetadata = themeMapReport.getApiMetadata();
        MetadataField rootFiled = ConvertGetAgileData.getRootMetadataField(apiMetadata);
        ListComponent listComponent = (ListComponent) listComponentImpl.initComponent(rootFiled, buildContext);
        listComponent.setItemsLayout("horizontal");
        listComponent.setGroup(components);
        listComponent.setIsFit(true);
        listComponent.setPagination(Maps.newHashMap());
        listComponent.setId(themeMapReport.getDataSource());
        return listComponent;
    }

    /**
     * 构建卡片
     *
     * @param themeMapReport
     * @param progressBarComponent
     * @param buildContext
     * @return
     */
    private CardComponent createCard(ThemeMapReport themeMapReport, ProgressBarComponent progressBarComponent, BuildContext buildContext) {
        //元数据结构
        AgileReportCard agileReportCard = themeMapReport.getCard();
        MetadataField rootFiled = ConvertGetAgileData.getRootMetadataField(themeMapReport.getApiMetadata());
        Map<String, MetadataField> filedMap = ConvertGetAgileData.getAgileData(themeMapReport.getDataSource(), themeMapReport.getApiMetadata());
        CardComponent cardComponent = (CardComponent) cardComponentImpl.initComponent(rootFiled, buildContext);
        cardComponent.setId(themeMapReport.getDataSource() + "_card");
        cardComponent.setPath(cardComponent.getId());
        cardComponent.setId(null);
        //获取头部区域
        AgileReportCardDTO.AgileReportCardInfo header = agileReportCard.getCardDefine().getHeader();
        if (header != null) {
            //获取头部定义
            List<AbstractComponentField> fields = Lists.newArrayList();
            header.getAreaDefine().stream().forEach(item -> {
                if(MapUtils.isEmpty(filedMap)){
                    return;
                }
                MetadataField metadataField = filedMap.get(item.getApplyToField());
                if (metadataField == null) {
                    return;
                }
                AbstractComponentField field = new AbstractComponentField();
                field.setPath(rootFiled.getName());
                field.setSchema(metadataField.getName());
                field.setLabel(getLabel(metadataField, item.getLabel(), item.getShowLabel()));
                field.setPosition(item.getPosition());
                field.setFormat(metadataField.getPercent());
                field.setLevel(item.getLevel());
                field.setColor(item.getColor());
                fields.add(field);
            });
            CardHeader cardHeader = new CardHeader();
            cardHeader.setTitles(fields);
            cardComponent.setHeader(cardHeader);
        }
        //获取内容区域
        AgileReportCardDTO.AgileReportCardInfo body = agileReportCard.getCardDefine().getBody();
        if (body != null) {
            //获取内容定义定义
            Optional<AgileDataAreaDefine> showFieldsOption = body.getAreaDefine().stream().filter(item -> StringUtils.equals("showFields", item.getType())).findFirst();
            if (showFieldsOption.isPresent()) {
                AgileDataAreaDefine showFields = showFieldsOption.get();
                CardBody cardBody = new CardBody();
                List<AbstractComponentField> fields = Lists.newArrayList();
                showFields.getAreaDefine().stream().forEach(item -> {
                    if(MapUtils.isEmpty(filedMap)){
                        return;
                    }
                    MetadataField metadataField = filedMap.get(item.getApplyToField());
                    if (metadataField == null) {
                        return;
                    }
                    AbstractComponentField field = new AbstractComponentField();
                    field.setPath(rootFiled.getName());
                    field.setSchema(item.getApplyToField());
                    field.setLabel(getLabel(metadataField, item.getLabel(), item.getShowLabel()));
                    field.setFormat(metadataField.getPercent());
                    field.setPosition(item.getPosition());
                    field.setLevel(item.getLevel());
                    field.setColor(item.getColor());
                    fields.add(field);
                });
                List<AbstractComponent> group = Lists.newArrayList();
                if (progressBarComponent != null) {
                    group.add(progressBarComponent);
                }
                cardBody.setGroup(group);
                cardBody.setFields(fields);
                cardBody.setFieldsLayout(showFieldsOption.get().getFieldsLayout());
                cardComponent.setBody(cardBody);
            }
        }
        //获取底部区域
        AgileReportCardDTO.AgileReportCardInfo footer = agileReportCard.getCardDefine().getFooter();
        if (footer != null) {
            //获取头部定义
            List<AbstractComponentField> fields = Lists.newArrayList();
            footer.getAreaDefine().stream().forEach(item -> {
                if(MapUtils.isEmpty(filedMap)){
                    return;
                }
                MetadataField metadataField = filedMap.get(item.getApplyToField());
                if (metadataField == null) {
                    return;
                }
                AbstractComponentField field = new AbstractComponentField();
                field.setPath(rootFiled.getName());
                field.setSchema(metadataField.getName());
                field.setLabel(getLabel(metadataField, item.getLabel(), item.getShowLabel()));
                field.setPosition(item.getPosition());
                field.setLevel(item.getLevel());
                field.setFormat(metadataField.getPercent());
                field.setColor(item.getColor());
                fields.add(field);
            });
            CardFooter cardFooter = new CardFooter();
            cardFooter.setFields(fields);
            cardFooter.setFieldsLayout(footer.getFieldsLayout());
            cardComponent.setFooter(cardFooter);
        }

        return cardComponent;
    }

    /**
     * 构建进度条
     *
     * @param themeMapReport
     * @param buildContext
     * @return
     */
    private ProgressBarComponent createProgressBar(ThemeMapReport themeMapReport, BuildContext buildContext) {
        AgileReportCard agileReportCard = themeMapReport.getCard();
        //获取内容区域进度条定义
        AgileReportCardDTO.AgileReportCardInfo body = agileReportCard.getCardDefine().getBody();
        if (body != null) {
            //获取动态区域定义
            Optional<AgileDataAreaDefine> progressBar = body.getAreaDefine().stream().filter(item -> StringUtils.equals("dynamicModule", item.getType())).findFirst();
            if (progressBar.isPresent()) {
                //元数据结构
                MetadataField rootFiled = ConvertGetAgileData.getRootMetadataField(themeMapReport.getApiMetadata());
                Map<String, MetadataField> filedMap = ConvertGetAgileData.getAgileData(themeMapReport.getDataSource(), themeMapReport.getApiMetadata());
                //构建进度条
                AgileDataAreaDefine dynamicModule = progressBar.get();
                ProgressBarComponent progressBarComponent = (ProgressBarComponent) progressBarComponentImpl.initComponent(rootFiled, buildContext);
                progressBarComponent.setProgressType(dynamicModule.getProgressType());
                progressBarComponent.setId(progressBarComponent.getId());
                progressBarComponent.setId(null);
                List<Map<String, Object>> fields = Lists.newArrayList();
                dynamicModule.getAreaDefine().stream().forEach(item -> {
                    if(MapUtils.isEmpty(filedMap)){
                        return;
                    }
                    MetadataField filed = filedMap.get(item.getApplyToField());
                    if (filed == null) {
                        return;
                    }
                    Map<String, Object> fieldMap = Maps.newHashMap();
                    fieldMap.put("schema", item.getApplyToField());
                    fieldMap.put("label", getLabel(filed, item.getLabel(), item.getShowLabel()));
                    fieldMap.put("format", filed != null ? filed.getPercent() : null);
                    fieldMap.put("color", item.getColor());
                    fields.add(fieldMap);
                });
                if (CollectionUtils.isEmpty(fields)) {
                    return null;
                }
                progressBarComponent.setFields(fields);
                progressBarComponent.setId(themeMapReport.getDataSource() + "_progress");
                return progressBarComponent;
            }
        }

        return null;
    }

    /**
     * 构建白板
     *
     * @param themeMapReport
     */
    public PanelComponent createPanel(ThemeMapReport themeMapReport, List<AbstractComponent> components, BuildContext buildContext) {
        AgileReportCard agileReportCard = themeMapReport.getCard();
        //构建筛选器
        if (agileReportCard.getFilter() != null) {
            ApiMetadata apiMetadata = themeMapReport.getApiMetadata();
            MetadataField rootFiled = ConvertGetAgileData.getRootMetadataField(apiMetadata);
            PanelComponent panelComponent = (PanelComponent) panelComponentImpl.initComponent(rootFiled, buildContext);
            //构建头部区域
            AbstractComponentHeader header = new AbstractComponentHeader();
            header.setTitle(themeMapReport.getTitle());
            header.setTitlePosition("left");
            //构建头部-操作区域
            Map<String, Object> optionMap = Maps.newHashMap();
            Map<String, Object> option = Maps.newLinkedHashMap();
            List<String> values = Lists.newArrayList();
            //获取规则
            AgileReportRuleDTO rule = agileReportCard.getFilter().getAgileReportRule();
            if (rule == null) {
                return panelComponent;
            }
            String showName = StringUtils.EMPTY;
            String showValue = StringUtils.EMPTY;
            Optional<AgileReportRuleInfoDTO> showNameRule = rule.getRules().stream().filter(item -> StringUtils.equals("showName", item.getType())).findFirst();
            Optional<AgileReportRuleInfoDTO> showValueRule = rule.getRules().stream().filter(item -> StringUtils.equals("showValue", item.getType())).findFirst();
            if (showNameRule.isPresent()) {
                showName = showNameRule.get().getApplyToField();
            }
            if (showValueRule.isPresent()) {
                showValue = showValueRule.get().getApplyToField();
            }
            optionMap.put("option", option);
            buildContext.setOption(optionMap);
            if (CollectionUtils.isNotEmpty(agileReportCard.getFilter().getPageData())) {
                for (Map<String, Object> item : agileReportCard.getFilter().getPageData()) {
                    option.put(MapUtils.getString(item, showValue), MapUtils.getString(item, showName));
                    values.add(MapUtils.getString(item, showValue));
                }
            }
            MetadataField selectFiled = ConvertGetAgileData.getRootMetadataField(agileReportCard.getFilter().getApiMetadata());
            AbstractComponent selectComponent = multipleSelectComponent.initComponent(selectFiled, buildContext);
            selectComponent.setId(agileReportCard.getFilter().getActionId() + "_select");
            selectComponent.setId(selectComponent.getId());
            selectComponent.setEditable(true);
            //获取敏捷数据个性化设置
            SceneSelectInfo selectInfo = new SceneSelectInfo();
            selectInfo.setSceneCode(buildContext.getExecuteContext().getScreenCode());
            selectInfo.setActionId(selectComponent.getId());
            selectInfo.setType("action");
            List<Object> moreSelectInfo = moreActionUserSelectService.queryMoreActionUserSelectInfo(selectInfo, buildContext.getExecuteContext().getAuthoredUser());
            List<String> userSelectInfo = moreSelectInfo.stream()
                    .map(Object::toString)
                    .collect(Collectors.toList());
            if (CollectionUtils.isEmpty(userSelectInfo)) {
                userSelectInfo = values;
            }
            List<AbstractComponent> group = Lists.newArrayList();
            group.add(selectComponent);
            header.setGroup(group);
            header.setGroupPosition("right");
            panelComponent.setHeader(header);
            AbstractComponentBody abstractComponentBody = new AbstractComponentBody();
            components.stream().forEach(item -> item.setPath(panelComponent.getId()));
            abstractComponentBody.setGroup(components);
            panelComponent.setBody(abstractComponentBody);
            //构建ID
            panelComponent.setId(themeMapReport.getDataSource() + "_panel");
            setPanelPageData(panelComponent, userSelectInfo, themeMapReport);
            return panelComponent;
        }

        return null;
    }

    /**
     * 获取label
     *
     * @param metadataField
     * @param label
     * @param isShowLabel
     * @return
     */
    private String getLabel(MetadataField metadataField, String label, Boolean isShowLabel) {
        if (BooleanUtils.isTrue(isShowLabel)) {
            if (StringUtils.isNotEmpty(label)) {
                return label;
            }
            if (metadataField != null) {
                return metadataField.getDescription();
            }
        }
        return null;
    }


}
