package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.*;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataDataDTO;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.metadata.MetadataService;
import com.digiwin.athena.show.service.AgileDataPageDefineService;
import com.digiwin.athena.show.util.ApiMetadataUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 敏捷数据模型中心定义
 */
@Service()
public class AgileDataPageDefineModelCenterService extends AgileDataPageDefineService {


    @Override
    public String supportKey() {
        return "AGILEDATA_DEFINE_1";
    }

    @Override
    protected void buildScreenModel(AgileReportKMData agileReportKMData, ExecuteContext executeContext) {
        return;
    }

    @Override
    protected Boolean judgeDefine(String judgeCode, ExecuteContext executeContext, ApiMetadata apiMetadata, List<Map<String, Object>> agileDataListList, TargetDTO targetDTO, List<Map<String, Object>> pageData) {
        return false;
    }

    @Override
    protected AgileReportKMData getAgileReportDefine(ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        AgileReportKMData agileReportKMData = this.getAgileReportChartData(snapDataDTO, executeContext);
//        agileReportKMData =  JSONUtil.toBean(
//                ResourceUtil.readUtf8Str("mock/FCI_demo_reportReport.json"),
//                AgileReportKMData.class);
        return agileReportKMData;
    }

    @Override
    protected ApiMetadata getApiMetadata(SnapDataDTO snapDataDTO, ExecuteContext executeContext, String actionId) {
        ApiMetadata apiMetadata = null;
        //优先使用敏捷引擎下发的元数据信息
        if (snapDataDTO.getPageData().get(actionId) != null) {
            Object obj = snapDataDTO.getPageData().get(actionId);
            Map<String, Object> actionMap = Maps.newHashMap();
            Map<String, Object> metadataMap = Maps.newHashMap();
            if (obj instanceof Map) {
                actionMap = (Map<String, Object>) obj;
            } else {
                List<Map<String, Object>> metadataList = (List<Map<String, Object>>) obj;
                if (!CollectionUtils.isEmpty(metadataList)) {
                    actionMap = metadataList.get(0);
                }
            }
            if (MapUtils.isNotEmpty(actionMap) &&
                    actionMap.containsKey("metadata")) {
                metadataMap = MapUtils.getMap(actionMap, "metadata");
            }
            MetadataDataDTO metadataDataDTO = null;
            //敏捷引擎无元数据，从KM获取
            if (MapUtils.isNotEmpty(metadataMap)) {
                metadataDataDTO = JsonUtils.jsonToObject(JsonUtils.objectToString(metadataMap), MetadataDataDTO.class);
            }
            //部分属性敏捷引擎不会下传，从KM获取
            if (metadataDataDTO != null) {
                apiMetadata = SpringUtil.getBean(MetadataService.class).createApiMetadata(metadataDataDTO);
            }
        }
        //敏捷引擎下发无元数据，直接通过KM接口获取
        if (apiMetadata == null) {
            apiMetadata = SpringUtil.getBean(MetadataService.class).getModelMetadata(executeContext.getLocale(), actionId);
        }
        return apiMetadata;
    }

    @Override
    protected AgileDataTag getAgileDataTag(SnapDataDTO snapDataDTO, ExecuteContext executeContext, String actionId) {
        return null;
    }

    @Override
    protected String getTitle(AgileReportShowTypeInfoDTO agileShowType, SnapDataDTO snapDataDTO, ApiMetadata apiMetadata, ThemeMapReport themeMapReport, ExecuteContext executeContext) {
        String title = agileShowType.getTitle();
        //获取查询日期
        String timeTitle = getModelCenterTitleDate(snapDataDTO, apiMetadata);
        title = timeTitle + title;
        //获取排序信息
        String sortTitle = getModelCenterTitleSort(snapDataDTO, themeMapReport);
        title = title + sortTitle;
        return title;
    }

    /**
     * 获取排序标题
     *
     * @param snapDataDTO
     * @param themeMapReport
     * @return
     */
    private String getModelCenterTitleSort(SnapDataDTO snapDataDTO, ThemeMapReport themeMapReport) {
        String sortTitle = "";
        if (CollectionUtils.isEmpty(snapDataDTO.getQuerySchema().getSortFields())) {
            return sortTitle;
        }
        List<AgileModelCenterSortField> sortFields = snapDataDTO.getQuerySchema().getSortFields();
        if (sortFields.size() == 1) {
            AgileModelCenterSortField agileModelCenterSortField = sortFields.get(0);
            if (StringUtils.equals("asc", agileModelCenterSortField.getOrder())) {
                sortTitle = "TOP " + themeMapReport.getPageData().size();
            }
            if (StringUtils.equals("desc", agileModelCenterSortField.getOrder())) {
                sortTitle = "DOWN " + themeMapReport.getPageData().size();
            }
        }
        return sortTitle;
    }

    /**
     * 获取语义资产日期名称
     *
     * @param snapDataDTO
     * @param apiMetadata
     * @return
     */
    private String getModelCenterTitleDate(SnapDataDTO snapDataDTO, ApiMetadata apiMetadata) {
        String dateTitle = "";
        if (snapDataDTO.getQuerySchema().getFilter() == null) {
            return dateTitle;
        }
        Map<String, MetadataField> apiMap = ConvertGetAgileData.getFiledMap(ConvertGetAgileData.getRootFiled(apiMetadata), apiMetadata);
        //需要递归语义信息，且查找到日期类型字段
        List<AgileModelCenterFilter> filterList = Lists.newArrayList();
        AgileModelCenterFilter agileModelCenterFilter = snapDataDTO.getQuerySchema().getFilter();
        if (agileModelCenterFilter == null) {
            return dateTitle;
        }
        MetadataField metadataField = apiMap.get(agileModelCenterFilter.getLeftValue());
        if (metadataField != null && StringUtils.equals("date", metadataField.getDataType())) {
            filterList.add(agileModelCenterFilter);
        }
        if (!CollectionUtils.isEmpty(agileModelCenterFilter.getChildren())) {
            filterList.addAll(this.getDateField(agileModelCenterFilter.getChildren(), apiMap));
        }
        //日期字段具备以下元素才可支持标题展示
        String startTime = "";
        String endTime = "";
        String time = "";
        int timeSize = 0;
        List<String> lessOperator = Lists.newArrayList("lt", "le");
        List<String> greaterOperator = Lists.newArrayList("gt", "ge");
        for (AgileModelCenterFilter modelCenterFilter : filterList) {
            //1.存在大于且存在小于日期
            if (greaterOperator.contains(modelCenterFilter.getOperator())) {
                if (StringUtils.isEmpty(startTime)) {
                    startTime = modelCenterFilter.getRightValue();
                } else {
                    startTime = "";
                }
            } else if (lessOperator.contains(modelCenterFilter.getOperator())) {
                if (StringUtils.isEmpty(endTime)) {
                    endTime = modelCenterFilter.getRightValue();
                } else {
                    endTime = "";
                }
            } else {
                //2.存在等于日期且只有1个
                if (timeSize > 0) {
                    time = "";
                } else {
                    time = modelCenterFilter.getRightValue();
                }
                timeSize++;
            }
        }
        if (StringUtils.isNotEmpty(startTime) && StringUtils.isNotEmpty(endTime)) {
            dateTitle = startTime + "~" + endTime;
        } else if (StringUtils.isNotEmpty(time)) {
            dateTitle = time;
        }
        return dateTitle;
    }

    /**
     * 获取日期类型条件
     *
     * @param filterList
     * @param apiMap
     * @return
     */
    private List<AgileModelCenterFilter> getDateField(List<AgileModelCenterFilter> filterList, Map<String, MetadataField> apiMap) {
        List<AgileModelCenterFilter> dateList = Lists.newArrayList();
        filterList.stream().forEach(filter -> {
            MetadataField metadataField = apiMap.get(filter.getLeftValue());
            if (metadataField != null && StringUtils.equals("date", metadataField.getDataType())) {
                dateList.add(filter);
            }
            if (!CollectionUtils.isEmpty(filter.getChildren())) {
                dateList.addAll(getDateField(filter.getChildren(), apiMap));
            }
        });
        return dateList;
    }

    /**
     * 语义呈现定义
     *
     * @param snapDataDTO
     * @return
     */
    private AgileReportKMData getAgileReportChartData(SnapDataDTO snapDataDTO, ExecuteContext executeContext) {
        AgileReportKMData agileReportKMData = new AgileReportKMData();
        AgileModelCenterDefine agileModelCenterDefine = snapDataDTO.getQuerySchema();
        if (agileModelCenterDefine == null) {
            return null;
        }

        /**
         * 呈现类型
         */
        //模型ID
        agileReportKMData.setActionId(agileModelCenterDefine.getModelId());
        //展现形式
        AgileReportShowTypeDTO agileReportShowTypeDTO = new AgileReportShowTypeDTO();
        AgileReportShowTypeInfoDTO showType = new AgileReportShowTypeInfoDTO();
        String biValue = ChartBITypeEnum.getValue(agileModelCenterDefine.getChartType());
        showType.setBiValue(biValue);
        //0.表格 2.指标 其他类型都先归于图表
        if (StringUtils.equals("0", biValue) || StringUtils.equals("2", biValue)) {
            showType.setValue(Integer.valueOf(biValue));
        } else {
            showType.setValue(1);
        }
        //标题
        showType.setTitle(snapDataDTO.getSnapData().getTitle());
        agileReportShowTypeDTO.setType(Lists.newArrayList(showType));

        /**
         * 解析以actionId为准，需将modelId的值作为actionId的值
         */
        this.completionModelData(snapDataDTO, agileModelCenterDefine.getModelId());


        /**
         * 呈现配置
         */
        AgileReportShow agileReportShow = new AgileReportShow();
        agileReportShow.setActionId(agileModelCenterDefine.getModelId());
        //模型中心，输出结果必须为data单头形式
        ApiMetadata apiMetadata = getApiMetadata(snapDataDTO, executeContext, agileModelCenterDefine.getModelId());
        //数据查找路径，需要使用的数据通过此路径获取
        agileReportShow.setTargetSource(super.getTargetSource(apiMetadata));
        switch (showType.getValue()) {
            case 1:
                //图表定义，不满足时转为表格
                this.buildEChartDefine(agileModelCenterDefine, agileReportShow, showType, apiMetadata);
                break;
            case 2:
                //指标定义
                agileReportShow.setAgileReportIndex(this.buildIndexDefine(agileReportShow, apiMetadata));
                break;
            case 0:
            default:
                break;
        }

        agileReportKMData.setShowType(Lists.newArrayList(agileReportShowTypeDTO));
        agileReportKMData.setShow(Lists.newArrayList(agileReportShow));
        return agileReportKMData;
    }

    /**
     * 构建图形定义
     *
     * @param agileModelCenterDefine
     * @param agileReportShow
     * @param showType
     * @param apiMetadata
     */
    private void buildEChartDefine(AgileModelCenterDefine agileModelCenterDefine, AgileReportShow agileReportShow, AgileReportShowTypeInfoDTO showType, ApiMetadata apiMetadata) {
        AgileReportEChartDefineDTO eChart = new AgileReportEChartDefineDTO();
        //暂持只支持简单的条件，比如2023的预测达成率，此维度就是2023年的月份
        if (CollectionUtils.isEmpty(agileModelCenterDefine.getDimensions())) {
            //语义给予条件不满足时，转为表格呈现
            showType.setValue(0);
            return;
        }
        AgileReportDataFindDTO agileReportDataFindDTO = new AgileReportDataFindDTO();
        //从元数据中查找字段(暂时只支持一个维度)，若字段不存在，进行模糊匹配
        String applyToField = ConvertGetAgileData.getApiFiled(agileReportShow.getTargetSource(), apiMetadata, agileModelCenterDefine.getDimensions().get(0).getField());
        //维度字段获取为空，取元数据字段(暂时只支持一个维度)
        if (StringUtils.isEmpty(applyToField)) {
            List<MetadataField> applyMetadataList = ConvertGetAgileData.getStringField("numeric", agileReportShow.getTargetSource(), apiMetadata, false);
            if (!CollectionUtils.isEmpty(applyMetadataList) && applyMetadataList.size() > 1) {
                //多个维度字段暂不支持，转为表格呈现
                showType.setValue(0);
                return;
            }
            MetadataField metadataField = applyMetadataList.get(0);
            applyToField = metadataField.getName();
        }
        //无法查询到维度字段，转为表格呈现
        if (StringUtils.isEmpty(applyToField)) {
            showType.setValue(0);
            return;
        }
        agileReportDataFindDTO.setApplyToField(applyToField);
        //暂持只支持简单的条件，比如2023的预测达成率，此维度就是2023年的预测达成率
        List<AgileReportDataFindDTO> seriesList = Lists.newArrayList();
        agileModelCenterDefine.getMeasures().stream().forEach(measures -> {
            String measureField = ConvertGetAgileData.getApiFiled(agileReportShow.getTargetSource(), apiMetadata, measures.getField());
            AgileReportDataFindDTO series = new AgileReportDataFindDTO();
            //从元数据中查找字段，若字段不存在，进行模糊匹配
            series.setApplyToField(measureField);
            seriesList.add(series);
        });
        //度量字段为空，取数字型字段
        if (CollectionUtils.isEmpty(seriesList)) {
            List<MetadataField> applyMetadataList = ConvertGetAgileData.getStringField("numeric", agileReportShow.getTargetSource(), apiMetadata, true);
            applyMetadataList.stream().forEach(serieMetadataField -> {
                AgileReportDataFindDTO seriesDTO = new AgileReportDataFindDTO();
                seriesDTO.setApplyToField(serieMetadataField.getName());
                seriesList.add(seriesDTO);
            });
            //找不到度量字段，转为表格呈现
            if (CollectionUtils.isEmpty(seriesList)) {
                showType.setValue(0);
                return;
            }
        }

        eChart.setXAxis(Arrays.asList(agileReportDataFindDTO));
        eChart.setSeries(seriesList);
        agileReportShow.setEChart(Lists.newArrayList(eChart));
    }

    /**
     * 构建指标定义
     *
     * @param agileReportShow
     * @param apiMetadata
     * @return
     */
    private AgileReportIndex buildIndexDefine(AgileReportShow agileReportShow, ApiMetadata apiMetadata) {
        AgileReportIndex agileReportIndex = new AgileReportIndex();
        List<AgileReportIndex.AgileDataDefineIndex> indexes = Lists.newArrayList();
        //从元数据获取
        ApiMetadata masterApi = ConvertGetAgileData.getMasterMetadata(agileReportShow.getTargetSource(), apiMetadata);
        ApiMetadataUtil.flatMetaData(masterApi);
        List<MetadataField> metadataFields = ConvertGetAgileData.getTargetFiled(agileReportShow.getTargetSource(), masterApi);
        if (!CollectionUtils.isEmpty(metadataFields)) {
            //取元素据结果结构，按业务字段进行指标卡配置构建
            metadataFields.stream().forEach(metadataField -> {
                AgileReportIndex.AgileDataDefineIndex agileDataDefineIndex = new AgileReportIndex.AgileDataDefineIndex();
                AgileReportRuleInfoDTO agileReportRuleInfoDTO = new AgileReportRuleInfoDTO();
                agileReportRuleInfoDTO.setApplyToField(metadataField.getName());
                agileDataDefineIndex.setTitle(agileReportRuleInfoDTO);
                agileDataDefineIndex.setValue(agileReportRuleInfoDTO);
                indexes.add(agileDataDefineIndex);
            });
        }
        agileReportIndex.setIndexes(indexes);
        //
//
//                if(CollectionUtils.isEmpty(pullList)){
//                    //取pull结果结构，按业务字段进行指标卡配置构建
//                    Map<String,Object> resultData = pullList.get(0);
//                    resultData.forEach((k,v) -> {
//                        AgileReportIndex.AgileDataDefineIndex agileDataDefineIndex = new AgileReportIndex.AgileDataDefineIndex();
//                        AgileReportRuleInfoDTO agileReportRuleInfoDTO = new AgileReportRuleInfoDTO();
//                        agileReportRuleInfoDTO.setApplyToField(k);
//                        agileDataDefineIndex.setTitle(agileReportRuleInfoDTO);
//                        agileDataDefineIndex.setValue(agileReportRuleInfoDTO);
//                        indexes.add(agileDataDefineIndex);
//                    });
//                }
//                agileReportIndex.setIndexes(indexes);
        return agileReportIndex;
    }

    /**
     * 获取语义业务数据
     *
     * @param snapDataDTO
     * @param modelId
     * @return
     */
    private List<Map<String, Object>> completionModelData(SnapDataDTO snapDataDTO, String modelId) {
        List<Map<String, Object>> pullList = Lists.newArrayList();
        Map<String, Object> paData = snapDataDTO.getPageData();
        //获取pullData结果集
        List<Map<String, Object>> pageList = Lists.newArrayList();
        Object pageObj = paData.get(modelId);
        if (pageObj instanceof Collection) {
            pageList = (List<Map<String, Object>>) pageObj;
        } else {
            pageList.add((Map<String, Object>) pageObj);
        }
        if (!CollectionUtils.isEmpty(pageList)) {
            for (Map<String, Object> data : pageList) {
                //设置actionId为模型ID
                data.put("actionId", modelId);
                Object pullData = data.get("data");
                if (pullData instanceof Collection) {
                    pullList = (List<Map<String, Object>>) pullData;
                } else {
                    pullList.add((Map<String, Object>) pullData);
                }
            }
        }
        return pullList;
    }
}
