package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.agiledataecho.service.EchoInformationService;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.show.assistant.AgileDataConstants;
import com.digiwin.athena.show.assistant.EchoShowConstants;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.*;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.manager.themeMap.ThemeAgileDataService;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataDataDTO;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.metadata.MetadataService;
import com.digiwin.athena.show.service.AgileDataPageDefineService;
import com.digiwin.athena.show.service.AgileDataThemeMapDefine;
import com.digiwin.athena.show.service.AgileDataTransDefineService;
import com.digiwin.athena.show.service.CompletionEchartsDefine;
import com.digiwin.athena.show.util.ApiMetadataUtil;
import com.digiwin.athena.show.util.layout.AgileDataCheck;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.utils.ChartDataQuery;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.crypto.interfaces.PBEKey;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * 敏捷数据图谱定义
 */
@Slf4j
@Service()
public class AgileDataPageDefineThemeMapService extends AgileDataPageDefineService {

    private static final List<String> DATE_FIELDS = Lists.newArrayList("date", "datetime");

    @Autowired
    private ThemeAgileDataService themeAgileDataService;

    @Autowired
    private EchoInformationService echoInformationService;

    @Autowired
    private MessageUtils messageUtils;

    @Autowired
    private AgileDataTransDefineService agileDataTransDefineService;

    @Autowired
    private List<AgileDataThemeMapDefine> agileDataThemeMapDefines;

    @Autowired
    private List<CompletionEchartsDefine> completionEchartsDefines;

    private static final String AGILE_DATA_DESCRIPTION = "缺少%s字段设定，无法呈现图形";

    private static final String AGILE_DATA_CONTENT = "当前取得的各个字段的中英文名称及其对应%s";

    private static final String AGILE_DATA_EXTEND = "图形需维度度量至少各有一个，指标卡需至少一个度量，才可呈现，请修改字段对应维度/度量，或者增加新的维度/度量字段";

    @Override
    public String supportKey() {
        return "AGILEDATA_DEFINE_0";
    }

    private AgileDataThemeMapDefine getPageDefine(ExecuteContext executeContext){
        String entry = MapUtils.getString(executeContext.getAgileData(), "entry", "0");
        AgileDataThemeMapDefine agileDataPageDefineService = null;
        for(AgileDataThemeMapDefine pageDefine : agileDataThemeMapDefines){
            String supportKey = "AGILE_DATA_DEFINE_" + entry;
            if(StringUtils.equals(pageDefine.supportKey(), supportKey)){
                agileDataPageDefineService = pageDefine;
                break;
            }
        }
        return agileDataPageDefineService;
    }

    private CompletionEchartsDefine getCompletionEchartsDefine(Integer showValue,AgileReportRuleDTO agileReportRuleDTO){
        if(agileReportRuleDTO != null){
            showValue = 4;
        }
        CompletionEchartsDefine echartsDefinedefine = null;
        for(CompletionEchartsDefine completionEchartsDefine : completionEchartsDefines){
            String supportKey = "ECHARTS_DEFINE_" + showValue;
            if(StringUtils.equals(completionEchartsDefine.supportKey(), supportKey)){
                echartsDefinedefine = completionEchartsDefine;
                break;
            }
        }
        return echartsDefinedefine;
    }

    /**
     * 大屏用户级模板定义
     * @param agileReportKMData
     * @param executeContext
     */
    @Override
    protected void buildScreenModel(AgileReportKMData agileReportKMData, ExecuteContext executeContext) {
        Objects.requireNonNull(this.getPageDefine(executeContext)).buildScreenModel(agileReportKMData, executeContext);
    }

    @Override
    protected Boolean judgeDefine(String judgeCode, ExecuteContext executeContext, ApiMetadata apiMetadata, List<Map<String, Object>> agileDataListList, TargetDTO targetDTO, List<Map<String, Object>> pageData) {
        return Objects.requireNonNull(this.getPageDefine(executeContext)).judgeDefine(judgeCode, executeContext, apiMetadata, agileDataListList, targetDTO, pageData);
    }

    @Override
    protected AgileReportKMData getAgileReportDefine(ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        AgileReportKMData agileReportKMData;
        String code = executeContext.getReportCode();
        if (snapDataDTO.getShowDefine() != null && snapDataDTO.getShowDefine().getShowType() != null) {
            //POC呈现定义
            agileReportKMData = this.getAgileReportKMData(snapDataDTO);
        } else {
            //通过场景code获取呈现定义
            agileReportKMData = this.getSceneAgileReportKMData(snapDataDTO, code, executeContext);
        }
        completionDefine(agileReportKMData, executeContext, snapDataDTO);

        return agileReportKMData;
    }

    /**
     * 获取场景呈现定义
     *
     * @param snapDataDTO
     * @param code
     * @return
     */
    private AgileReportKMData getSceneAgileReportKMData(SnapDataDTO snapDataDTO, String code, ExecuteContext executeContext) {
        AgileReportKMData agileReportKMData = null;
        //优先通过场景code获取呈现定义
        if (StringUtils.isNotEmpty(code)) {
            agileReportKMData = themeAgileDataService.querySceneMaps(code);
        }
        //场景code呈现定义为空，通过actionId获取场景定义
        if (agileReportKMData == null) {
            agileReportKMData = this.getAgileReportKMData(snapDataDTO.getPageData());
        }
        String transId = executeContext.getTransId();
        if(StringUtils.isNotEmpty(transId) && agileReportKMData != null){
            agileReportKMData.getShowType().stream().forEach(showType -> showType.getType().stream().forEach(type -> type.setValue(Integer.valueOf(transId))));
        }
        return agileReportKMData;
    }

    /**
     * 按默认规则补全未配置定义
     *
     * @param agileReportKMData
     * @param executeContext
     * @param snapDataDTO
     */
    private void completionDefine(AgileReportKMData agileReportKMData, ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        if (agileReportKMData == null) {
            return;
        }
        if (CollectionUtils.isEmpty(agileReportKMData.getShow())) {
            agileReportKMData.setShow(Lists.newArrayList());
        }
        //根据呈现类型，查找对应的呈现配置
        agileReportKMData.getShowType().stream().forEach(showType -> showType.getType().stream().forEach(type -> {
            //元数据ID
            log.info("解析呈现类型：{}",JsonUtils.objectToString(showType));
            String actionId = showType.getActionId();
            //查找对应的show节点
            AgileReportShow showInfo;
            //找到呈现定义(show节点下)
            Optional<AgileReportShow> optionalShow = agileReportKMData.getShow().stream().filter(show -> StringUtils.equals(actionId, show.getActionId())).findFirst();
            if (optionalShow.isPresent()) {
                showInfo = optionalShow.get();
            } else {
                showInfo = new AgileReportShow();
                showInfo.setActionId(actionId);
                agileReportKMData.getShow().add(showInfo);
            }
            //获取元数据信息
            ApiMetadata apiMetadata = getApiMetadata(snapDataDTO, executeContext, actionId);
            log.info("获取元数据：{}",JsonUtils.objectToString(apiMetadata));
            if (apiMetadata == null) {
                return;
            }
            //通过pullData，查找数据分布情况
            Integer dimensionRelationShip = getAgileDataPullData(snapDataDTO, actionId);
            //移动端兼容处理
//            this.mobileDataRemove(executeContext,apiMetadata, type,snapDataDTO);
            //语义分析结果维度大于1时，暂时用表格呈现
            transTable(executeContext,apiMetadata, type, dimensionRelationShip, snapDataDTO);
            //展示类型(图/表格/指标卡)
            Integer showValue = type.getValue() == null ? 0 : type.getValue();
            showInfo.setSourceReportShow(showValue);
            //通过元数据结构，获取数据路径(object节点逐层递归)
            showInfo.setTargetSource(super.getTargetSource(apiMetadata));
            //是否需要转换
            agileDataTransDefineService.transEchartsDefine(type, showInfo, snapDataDTO, apiMetadata, actionId, showInfo.getTargetSource(),executeContext);
            log.info("补全呈现定义：{}",showValue);
            //呈现配置不满足定义时，按默认规则进行补全
            switch (ConvertAgileDataUtils.transType(showValue)) {
                case "chart":
                    //获取度量信息
                    Optional<AgileReportRuleDTO> agileReportRuleDTOOptional = Optional.empty();
                    //如果存在双轴规则，按规则分组度量字段
                    if (!CollectionUtils.isEmpty(showInfo.getAgileRule())) {
                        agileReportRuleDTOOptional = showInfo.getAgileRule().stream().filter(rule -> StringUtils.equals("doubleShaft", rule.getType())).findFirst();
                    }
                    AgileReportRuleDTO agileReportRuleDTO = agileReportRuleDTOOptional.isPresent() ? agileReportRuleDTOOptional.get() : null;
                    CompletionEchartsDefine completionEchartsDefine = getCompletionEchartsDefine(showValue,agileReportRuleDTO);
                    if(completionEchartsDefine != null) {
                        //补全图形定义
                        completionEchartsDefine.completionEchartsDefine(showInfo, agileReportKMData, apiMetadata, executeContext, dimensionRelationShip, agileReportRuleDTO);
                    }
                    break;
                case "2":
                    //补全指标定义
                    this.completionIndexDefine(showInfo, apiMetadata);
                    break;
                case "0":
                default:
                    break;
            }
        }));
    }

    /**
     * 获取pullData
     * @param snapDataDTO
     * @param actionId
     * @return
     */
    private Integer getAgileDataPullData(SnapDataDTO snapDataDTO, String actionId) {
        Integer dimensionRelationShip = null;
        //优先使用敏捷引擎下发的元数据信息中的dataTag
        if (snapDataDTO.getPageData().get(actionId) != null) {
            Object obj = snapDataDTO.getPageData().get(actionId);
            Map<String, Object> actionMap = Maps.newHashMap();
            Map<String, Object> dataTagMap;
            if (obj instanceof Map) {
                actionMap = (Map<String, Object>) obj;
            } else {
                List<Map<String, Object>> metadataList = (List<Map<String, Object>>) obj;
                if (!CollectionUtils.isEmpty(metadataList)) {
                    actionMap = metadataList.get(0);
                }
            }
            if (MapUtils.isNotEmpty(actionMap) &&
                    actionMap.containsKey("dimensionRelationShip")) {
                dimensionRelationShip = MapUtils.getInteger(actionMap, "dimensionRelationShip");
            }

        }
        return dimensionRelationShip;
    }

    private void mobileDataRemove(ExecuteContext executeContext,ApiMetadata apiMetadata,AgileReportShowTypeInfoDTO showType,
                            SnapDataDTO snapDataDTO){

        //移动端临时兼容，1119版本删除
        if(StringUtils.equals(EchoShowConstants.MOBILE_PLATFORM, executeContext.getClientAgent())){
            if(!CollectionUtils.isEmpty(snapDataDTO.getPageData())) {
                List<Map<String,Object>> dataList = null;
                List<Map<String,Object>> datas = (List<Map<String, Object>>) snapDataDTO.getPageData().get(apiMetadata.getActionId());
                for(Map<String,Object> dataMap : datas) {
                    Map<String, Object> data = (Map<String, Object>) dataMap.get("data");
                    if(MapUtils.isNotEmpty(data)){
                        dataList = (List<Map<String, Object>>) data.get("data");
                    }
                }
                List<MetadataField> dimensionField = ConvertGetAgileData.getStringField("numeric", "data", apiMetadata, false);
                if(!CollectionUtils.isEmpty(dimensionField) && dataList != null) {
                    ChartBase chartBase = new ChartBase();
                    chartBase.setDatas(dataList);
                    //呈现为散点图时，维度数据汇总，至少有一个汇总结果小于20
                    if (8 == showType.getValue() || 9 == showType.getValue()) {
                        MetadataField field = dimensionField.get(0);
                        List<String> data = ChartDataQuery.getChartData(chartBase, field.getName());
                        data = data.stream().distinct().collect(Collectors.toList());
                        if(!CollectionUtils.isEmpty(data) && data.size() > 10){
                            data = data.subList(0, 10);
                            //删除不存在data中的数据
                            List<String> finalData = data;
                            dataList.removeIf(dataMap -> !finalData.contains(dataMap.get(field.getName())));
                        }
                    }
                }
            }
        }
    }

    private void transTable(ExecuteContext executeContext,ApiMetadata apiMetadata,AgileReportShowTypeInfoDTO showType,
                            Integer dimensionRelationShip,SnapDataDTO snapDataDTO){
        //ppt分析时，指标卡转表格
        if(StringUtils.equals(AgileDataConstants.STANDARD_PAGE, executeContext.getPageCode())){
            if(CollectionUtils.isEmpty(snapDataDTO.getPageData())) {
                return;
            }
            List<Map<String,Object>> dataList = null;
            List<Map<String,Object>> datas = (List<Map<String, Object>>) snapDataDTO.getPageData().get(apiMetadata.getActionId());
            for(Map<String,Object> dataMap : datas) {
                Map<String, Object> data = (Map<String, Object>) dataMap.get("data");
                if(MapUtils.isNotEmpty(data)){
                    dataList = (List<Map<String, Object>>) data.get("data");
                }
            }
            if(CollectionUtils.isEmpty(dataList)){
                return;
            }
            //气泡/散点图例过长，转为表格
            if(showType.getValue() == AgileReportChartTypeEnum.SCATTER_1.getValue()
                || showType.getValue() == AgileReportChartTypeEnum.SCATTER_2.getValue()){
                List<MetadataField> dimensionField = ConvertGetAgileData.getStringField("numeric", "data", apiMetadata, false);
                if(!CollectionUtils.isEmpty(dimensionField) && dimensionField.size() > 1 && dataList != null) {
                    ChartBase chartBase = new ChartBase();
                    chartBase.setDatas(dataList);
                    //呈现为散点图时，维度数据汇总，至少有一个汇总结果小于20
                    MetadataField field = dimensionField.get(0);
                    List<String> data = ChartDataQuery.getChartData(chartBase, field.getName());
                    data = data.stream().distinct().collect(Collectors.toList());
                    if(!CollectionUtils.isEmpty(data) && data.size() > 10){
                        showType.setValue(0);
                        return;
                    }
                }
            }
            //表格双列，存在数值和文本字段，且集合长度大于10笔，转为柱状图
            if(0 == showType.getValue() && dataList != null && dataList.size() > 10){
                List<MetadataField> dimensionField = ConvertGetAgileData.getStringField("numeric", "data", apiMetadata, false);
                if(CollectionUtils.isEmpty(dimensionField) || dimensionField.size() > 1){
                    return;
                }
                List<MetadataField> measurementField = ConvertGetAgileData.getStringField("numeric", "data", apiMetadata, true);
                if(CollectionUtils.isEmpty(measurementField) || measurementField.size() > 1){
                    return;
                }
                showType.setValue(3);
                return;
            }
        }
        List<MetadataField> dimensionFields = Lists.newArrayList();
        apiMetadata.getResponseFields().forEach(metadataField -> {
            if(metadataField.isObjectField()){
                dimensionFields.addAll(getDimensionFields(metadataField));
            }
        });
        if(CollectionUtils.isEmpty(dimensionFields)){
            return;
        }
        //某些图形为双维度/多度量，无需转表格
        if(ConvertAgileDataUtils.isMoreMetadataChart(showType.getValue(),dimensionFields)){
            return;
        }
        //双维度，数据分布为1对1关系，无需转表格
        if(dimensionFields.size() == 2 && (dimensionRelationShip != null && dimensionRelationShip == 0)){
            return;
        }
        if(dimensionFields.size() > 1){
            showType.setValue(0);
        }

    }

    private List<MetadataField> getDimensionFields(MetadataField metadataField){
        List<MetadataField>  metadataFields = Lists.newArrayList();
        if(metadataField.isObjectField()){
            metadataField.getSubFields().stream().forEach(subField -> metadataFields.addAll(getDimensionFields(subField)));
        } else {
            //补齐精度
            if(!StringUtils.equals(AgileDataConstants.DataType.NUMERIC,metadataField.getDataType())){
                metadataFields.add(metadataField);
            }
        }
        return metadataFields;
    }




    /**
     * 补全指标定义
     *
     * @param showInfo
     * @param apiMetadata
     */
    private void completionIndexDefine(AgileReportShow showInfo, ApiMetadata apiMetadata) {
        if (showInfo.getAgileReportIndex() == null) {
            ApiMetadata masterApi = ConvertGetAgileData.getMasterMetadata(showInfo.getTargetSource(), apiMetadata);
            ApiMetadataUtil.flatMetaData(masterApi);
            List<MetadataField> metadataFields = ConvertGetAgileData.getTargetFiled(showInfo.getTargetSource(), masterApi);
            AgileReportIndex agileReportIndex = new AgileReportIndex();
            List<AgileReportIndex.AgileDataDefineIndex> indexes = Lists.newArrayList();
            if (!CollectionUtils.isEmpty(metadataFields)) {
                //取元素据结果结构，按业务字段进行指标卡配置构建
                metadataFields.stream().forEach(metadataField -> {
                    AgileReportIndex.AgileDataDefineIndex agileDataDefineIndex = new AgileReportIndex.AgileDataDefineIndex();
                    AgileReportRuleInfoDTO agileReportRuleInfoDTO = new AgileReportRuleInfoDTO();
                    agileReportRuleInfoDTO.setApplyToField(metadataField.getName());
                    agileDataDefineIndex.setTitle(agileReportRuleInfoDTO);
                    agileDataDefineIndex.setValue(agileReportRuleInfoDTO);
                    indexes.add(agileDataDefineIndex);
                });
            }
            agileReportIndex.setIndexes(indexes);
            showInfo.setAgileReportIndex(agileReportIndex);
        }
    }

    /**
     * 补全卡片配置
     *
     * @param showInfo
     */
    private void completionCardDefine(AgileReportShow showInfo) {
        //卡片必须走设计器配置，否则不做呈现
        if (CollectionUtils.isEmpty(showInfo.getAgileRule())) {
            return;
        }
        Optional<AgileReportRuleDTO> agileReportRuleDTOOptional = showInfo.getAgileRule().stream().filter(rule -> StringUtils.equals("card", rule.getType())).findFirst();
        AgileReportRuleDTO ruleDTO = agileReportRuleDTOOptional.orElse(null);
        if (ruleDTO == null) {
            return;
        }
        AgileReportCardDTO agileReportCard = new AgileReportCardDTO();
        ruleDTO.getRules().stream().forEach(rule -> {
            switch (rule.getType()) {
                case "header":
                    AgileReportCardDTO.AgileReportCardInfo header = new AgileReportCardDTO.AgileReportCardInfo();
                    header.setAreaDefine(rule.getAreaDefine());
                    header.setType(rule.getType());
                    agileReportCard.setHeader(header);
                    break;
                case "body":
                    AgileReportCardDTO.AgileReportCardInfo body = new AgileReportCardDTO.AgileReportCardInfo();
                    body.setAreaDefine(rule.getAreaDefine());
                    body.setFieldsLayout(rule.getFieldsLayout());
                    body.setType(rule.getType());
                    agileReportCard.setBody(body);
                    break;
                case "footer":
                    AgileReportCardDTO.AgileReportCardInfo footer = new AgileReportCardDTO.AgileReportCardInfo();
                    footer.setAreaDefine(rule.getAreaDefine());
                    footer.setFieldsLayout(rule.getFieldsLayout());
                    footer.setType(rule.getType());
                    agileReportCard.setFooter(footer);
                    break;
                default:
                    break;
            }
        });
        showInfo.setCard(agileReportCard);
    }


    @Override
    protected ApiMetadata getApiMetadata(SnapDataDTO snapDataDTO, ExecuteContext executeContext, String actionId) {
        ApiMetadata apiMetadata = null;
        boolean isNeedKM =  !StringUtils.equals("2", snapDataDTO.getLink());
        //优先使用敏捷引擎下发的元数据信息
        if (snapDataDTO.getPageData().get(actionId) != null) {
            Object obj = snapDataDTO.getPageData().get(actionId);
            Map<String, Object> actionMap = Maps.newHashMap();
            Map<String, Object> metadataMap = Maps.newHashMap();
            if (obj instanceof Map) {
                actionMap = (Map<String, Object>) obj;
            } else {
                List<Map<String, Object>> metadataList = (List<Map<String, Object>>) obj;
                if (!CollectionUtils.isEmpty(metadataList)) {
                    actionMap = metadataList.get(0);
                }
            }
            if (MapUtils.isNotEmpty(actionMap) &&
                    actionMap.containsKey("metadata")) {
                metadataMap = MapUtils.getMap(actionMap, "metadata");
            }
            MetadataDataDTO metadataDataDTO = null;
            //敏捷引擎无元数据，从KM获取
            if (MapUtils.isNotEmpty(metadataMap)) {
                metadataDataDTO = JsonUtils.jsonToObject(JsonUtils.objectToString(metadataMap), MetadataDataDTO.class);
            }
            //部分属性敏捷引擎不会下传，从KM获取
            if (metadataDataDTO != null) {
                apiMetadata = SpringUtil.getBean(MetadataService.class).createApiMetadata(metadataDataDTO);
                //新架构不从KM获取
                if (isNeedKM) {
                    ApiMetadata originalApiMetadata = SpringUtil.getBean(MetadataService.class).getMetadata(executeContext.getLocale(), actionId);
                    if (actionMap != null && originalApiMetadata != null) {
                        apiMetadata.setSceneNodeType(originalApiMetadata.getSceneNodeType());
                        apiMetadata.setName(originalApiMetadata.getName());
                        apiMetadata.setServiceName(originalApiMetadata.getServiceName());
                        apiMetadata.setActionId(originalApiMetadata.getActionId());
                    }
                } else {
                    apiMetadata.setActionId(actionId);
                }

            }
        }
        if (isNeedKM && apiMetadata == null) {
            try {
                apiMetadata = SpringUtil.getBean(MetadataService.class).getMetadata(executeContext.getLocale(), actionId);
            } catch (Exception e) {
                log.error("获取KM元数据异常：{}", e.getMessage());
            }
        }
        //将dataTag属性放入元数据中
        completionMetadataTag(apiMetadata,snapDataDTO,actionId,executeContext);
        return apiMetadata;
    }


    /**
     * 填充dataTag属性至元数据中
     * @param apiMetadata
     * @param snapDataDTO
     * @param actionId
     * @param executeContext
     */
    private void completionMetadataTag(ApiMetadata apiMetadata,SnapDataDTO snapDataDTO,String actionId,ExecuteContext executeContext){
        AgileDataTag agileDataTag = getAgileDataTag(snapDataDTO,executeContext,actionId);
        if(agileDataTag == null){
            return;
        }
        if(CollectionUtils.isEmpty(agileDataTag.getFields())){
            return;
        }
        MetadataField rootMetadataField = ConvertGetAgileData.getRootMetadataField(apiMetadata);
        Map<String,MetadataField> metadataMap = ConvertGetAgileData.getAgileData(rootMetadataField.getName(),apiMetadata);
        agileDataTag.getFields().stream().forEach(valueField -> {
            String field = MapUtils.getString(valueField,"field",StringUtils.EMPTY);
            MetadataField metadataField = metadataMap.get(field);
            if(metadataField != null){
                metadataField.setBusinessType(MapUtils.getString(valueField,"businessType",StringUtils.EMPTY));
                metadataField.setDecimalRule(MapUtils.getString(valueField,"decimalRule"));
                metadataField.setExplanation(MapUtils.getString(valueField,"explanation",StringUtils.EMPTY));
                metadataField.setUnit(MapUtils.getString(valueField,"dataUnit"));
                metadataField.setIsTime(MapUtils.getBoolean(valueField,"isTime",false));
            }
        });
    }


    @Override
    protected AgileDataTag getAgileDataTag(SnapDataDTO snapDataDTO, ExecuteContext executeContext, String actionId) {
        AgileDataTag agileDataTag = null;
        //优先使用敏捷引擎下发的元数据信息中的dataTag
        if (snapDataDTO.getPageData().get(actionId) != null) {
            Object obj = snapDataDTO.getPageData().get(actionId);
            Map<String, Object> actionMap = Maps.newHashMap();
            Map<String, Object> dataTagMap;
            if (obj instanceof Map) {
                actionMap = (Map<String, Object>) obj;
            } else {
                List<Map<String, Object>> metadataList = (List<Map<String, Object>>) obj;
                if (!CollectionUtils.isEmpty(metadataList)) {
                    actionMap = metadataList.get(0);
                }
            }
            if (MapUtils.isNotEmpty(actionMap) &&
                    actionMap.containsKey("dataTag")) {
                dataTagMap = MapUtils.getMap(actionMap, "dataTag");
                agileDataTag = JsonUtils.jsonToObject(JsonUtils.objectToString(dataTagMap), AgileDataTag.class);
            }

        }
        //不存在，则使用语义提供的dataTag
        if(agileDataTag == null && snapDataDTO.getShowDefine() !=null){
            agileDataTag = snapDataDTO.getShowDefine().getDataTag();
        }
        return agileDataTag;
    }



    @Override
    protected String getTitle(AgileReportShowTypeInfoDTO agileShowType, SnapDataDTO snapDataDTO, ApiMetadata apiMetadata, ThemeMapReport themeMapReport, ExecuteContext executeContext) {
        String title = null;
        //用户自定义标题
        if(StringUtils.isNotEmpty(executeContext.getDefineTitle())){
            title = executeContext.getDefineTitle();
        }
        //大屏入口优化获取板块标题
        if(AgileDataCheck.isScreen(executeContext)) {
            title = agileShowType.getSectionName();
        }
        //其他入口获取数据流/指标 标题
        if(StringUtils.isEmpty(title)){
            title = agileShowType.getTitle();
        }
        //都未配置获取元数据名称
        if (StringUtils.isEmpty(title)) {
            title = themeMapReport.getApiMetadata().getName();
        }
        //都为配置不获取标题
        if (StringUtils.isEmpty(title)) {
            return title;
        }
        Map<String, List<AgileKMConditionLimitRecast>> recast = snapDataDTO.getBackRecast();
        if (MapUtils.isEmpty(recast)) {
            return title;
        }
        //获取日期标题
        String dateTitle = this.buildDateTitle(recast);
        title = dateTitle + title;
        //获取排序标题
        String sortTitle = this.buildSortTitle(recast);
        title = title + sortTitle;
        return title;
    }

    private String buildSortTitle(Map<String, List<AgileKMConditionLimitRecast>> recast) {
        String sortTitle = "";
        String limitNum = "";
        AgileKMConditionLimitRecast limitRecast = null;
        AgileKMConditionLimitRecast sortRecast = null;
        for (List<AgileKMConditionLimitRecast> recastList : recast.values()) {
            Optional<AgileKMConditionLimitRecast> optRecast = recastList.stream().filter(x -> StringUtils.equals("limit", x.getName())).findFirst();
            if (optRecast.isPresent()) {
                limitRecast = optRecast.get();
            }
            Optional<AgileKMConditionLimitRecast> optSort = recastList.stream().filter(x -> StringUtils.equals("sort", x.getName())).findFirst();
            if (optSort.isPresent()) {
                sortRecast = optSort.get();
            }
        }
        //默认使用limit的direction输出语句
        if (limitRecast != null) {
            List<AgileKMConditionLimitStatistic> statistics = limitRecast.getCondition().getStatistics();
            if (!CollectionUtils.isEmpty(statistics)) {
                AgileKMConditionLimitStatistic statistic = statistics.get(0);
                if (StringUtils.equals("head", statistic.getDirection())) {
                    sortTitle = "TOP ";
                }
                if (StringUtils.equals("tail", statistic.getDirection())) {
                    sortTitle = "DOWN ";
                }
                if (statistic.getStartPos() == null || Integer.valueOf(statistic.getStartPos()) < 1) {
                    limitNum += Integer.valueOf(statistic.getEndPos()) + 1;
                }
            }
        }
        //如果存在sort,使用sort进行语句输出
        if (sortRecast != null) {
            List<AgileKMConditionLimitStatistic> statistics = sortRecast.getCondition().getStatistics();
            if (!CollectionUtils.isEmpty(statistics)) {
                AgileKMConditionLimitStatistic statistic = statistics.get(0);
                if (StringUtils.equals("desc", statistic.getType())) {
                    sortTitle = "TOP ";
                }
                if (StringUtils.equals("asc", statistic.getType())) {
                    sortTitle = "DOWN ";
                }
            }
        }
        //无排序值，不展示排序标题
        if (StringUtils.isEmpty(limitNum)) {
            sortTitle = "";
        } else {
            sortTitle += limitNum;
        }
        return sortTitle;
    }

    /**
     * 补偿标题日期
     *
     * @param recast
     * @return
     */
    private String buildDateTitle(Map<String, List<AgileKMConditionLimitRecast>> recast) {
        String dateTitle = "";
        AgileKMConditionLimitRecast titleRecast = null;
        for (List<AgileKMConditionLimitRecast> recastList : recast.values()) {
            Optional<AgileKMConditionLimitRecast> optRecast = recastList.stream().filter(x -> StringUtils.equals("filter", x.getName())).findFirst();
            if (optRecast.isPresent()) {
                titleRecast = optRecast.get();
            }
        }
        if (titleRecast != null) {
            AgileKMConditionLimitCondition agileKMConditionLimitCondition = titleRecast.getCondition();
            List<AgileKMConditionItem> items = agileKMConditionLimitCondition.getItems();
            //日期字段具备以下元素才可支持标题展示
            String startTime = "";
            String endTime = "";
            String time = "";
            List<String> lessOperator = Lists.newArrayList("lt", "le", "lte");
            List<String> greaterOperator = Lists.newArrayList("gt", "ge", "gte");
            for (AgileKMConditionItem item : items) {
                if (!CollectionUtils.isEmpty(item.getItems())) {
                    if (StringUtils.equals("and", item.getLogitype())) {
                        for (AgileKMConditionItem dateItem : item.getItems()) {
                            if (DATE_FIELDS.contains(dateItem.getRight_value_type())) {
                                String right = dateItem.getRight().toString();
                                //日期类型，且大于/小于，只存在一种
                                if (lessOperator.contains(dateItem.getOp())) {
                                    endTime = StringUtils.isEmpty(endTime) ? transData(right) : StringUtils.EMPTY;
                                }
                                if (greaterOperator.contains(dateItem.getOp())) {
                                    startTime = StringUtils.isEmpty(startTime) ? transData(right) : StringUtils.EMPTY;
                                }
                            }
                        }
                    }
                } else {
                    String right = item.getRight().toString();
                    //只存在一种日期条件
                    if (DATE_FIELDS.contains(item.getRight_value_type()) &&
                            StringUtils.equals("eq", item.getOp())) {
                        time = StringUtils.isEmpty(time) ? transData(right) : StringUtils.EMPTY;
                    }
                    //日期类型，且大于/小于，只存在一种
                    if (DATE_FIELDS.contains(item.getRight_value_type()) && lessOperator.contains(item.getOp())) {
                        endTime = StringUtils.isEmpty(endTime) ? transData(right) : StringUtils.EMPTY;
                    }
                    if (DATE_FIELDS.contains(item.getRight_value_type()) && greaterOperator.contains(item.getOp())) {
                        startTime = StringUtils.isEmpty(startTime) ? transData(right) : StringUtils.EMPTY;
                    }
                }
            }
            if (StringUtils.isNotEmpty(startTime) && StringUtils.isNotEmpty(endTime)) {
                dateTitle = startTime + "~" + endTime;
            } else if (StringUtils.isNotEmpty(time)) {
                dateTitle = time;
            }
        }
        return dateTitle;
    }

    private String transData(String date) {
        String formatDate = date;
        if (StringUtils.isNotEmpty(date)) {
            try {
                formatDate = TimeUtils.format(TimeUtils.parseDate(date, "yyyy-MM-dd"), "yyyy.MM.dd");
            } catch (Exception e) {
                log.error("语义日期转换错误，原日期格式：{}" + date);
            }
        }
        return formatDate;
    }


    /**
     * 获取呈现定义
     *
     * @param snapDataDTO
     * @return
     */
    private AgileReportKMData getAgileReportKMData(SnapDataDTO snapDataDTO) {
        AgileReportKMData agileReportKMData = new AgileReportKMData();
        agileReportKMData.setShow(snapDataDTO.getShowDefine().getShow());
        agileReportKMData.setShowType(snapDataDTO.getShowDefine().getShowType());
        agileReportKMData.setActionId(snapDataDTO.getShowDefine().getShowType()
                .stream().map(AgileReportShowTypeDTO::getActionId).collect(Collectors.joining(",")));
        return agileReportKMData;
    }


    /**
     * 获取数据图谱定义
     *
     * @param pageData
     * @return
     */
    private AgileReportKMData getAgileReportKMData(Map<String, Object> pageData) {
        AgileReportKMData agileReportKMData = new AgileReportKMData();
        if (MapUtils.isNotEmpty(pageData)) {
            List<String> actionIds = Lists.newArrayList();
            Set<String> sceneCodes = Sets.newHashSet();
            pageData.forEach((x, y) -> {
                List<Map<String, Object>> actionList = (List<Map<String, Object>>) y;
                if (!CollectionUtils.isEmpty(actionList)) {
                    actionList.stream().forEach(actionMap -> {
                        if (actionMap.containsKey("actionId")) {
                            //通过查询KM，获取数据图谱默认定义入参
                            actionIds.add(MapUtils.getString(actionMap, "actionId", ""));
                            sceneCodes.add(MapUtils.getString(actionMap, "sceneCode", ""));
                        }
                    });
                }
            });
            //获取数据图谱定义
            if (!CollectionUtils.isEmpty(actionIds)) {
                List<AgileReportKMData> agileDataList = themeAgileDataService.querySceneMapsByActionId(actionIds);
                if (CollectionUtils.isEmpty(agileDataList)) {
                    return getAgileDataByCode(sceneCodes);
                }
                if (!CollectionUtils.isEmpty(agileDataList)) {
                    agileReportKMData.setActionId(String.join(",", actionIds));
                    List<AgileReportShow> agileReportShowList = Lists.newArrayList();
                    List<AgileReportShowTypeDTO> agileReportShowTypeDTOList = Lists.newArrayList();
                    agileDataList.stream().forEach(agileData -> {
                        agileData.getShow().stream().forEach(show -> show.setActionId(agileData.getActionId()));
                        agileReportShowList.addAll(agileData.getShow());
                        agileData.getShowType().stream().forEach(showType -> showType.setActionId(agileData.getActionId()));
                        agileReportShowTypeDTOList.addAll(agileData.getShowType());
                    });
                    agileReportKMData.setShow(agileReportShowList);
                    agileReportKMData.setShowType(agileReportShowTypeDTOList);
                }
            }
        }
        return agileReportKMData;
    }

    /**
     * 批量根据code查询场景图谱
     *
     * @param codes
     * @return
     */
    private AgileReportKMData getAgileDataByCode(Set<String> codes) {
        AgileReportKMData agileReportKMData = new AgileReportKMData();
        StringBuilder actionBuilder = new StringBuilder();
        List<AgileReportShow> show = Lists.newArrayList();
        List<AgileReportShowTypeDTO> showType = Lists.newArrayList();
        codes.stream().forEach(code -> {
            AgileReportKMData agileData = themeAgileDataService.querySceneMaps(code);
            if (agileData != null) {
                agileReportKMData.setScene(agileData.getScene());
                agileReportKMData.setCode(agileData.getCode());
                actionBuilder.append(agileData.getActionId()).append(",");
                agileReportKMData.setSceneTitle(agileData.getSceneTitle());
                agileReportKMData.setPageTurningFrequency(agileData.getPageTurningFrequency());
                agileReportKMData.setActionRelation(agileData.getActionRelation());
                if (!CollectionUtils.isEmpty(agileData.getShow())) {
                    show.addAll(agileData.getShow());
                }
                if (!CollectionUtils.isEmpty(agileData.getShowType())) {
                    showType.addAll(agileData.getShowType());
                }
            }
        });
        String actionId = actionBuilder.toString();
        if (!StringUtils.isEmpty(actionId)) {
            actionId = actionId.substring(0, actionId.length() - 1);
            agileReportKMData.setActionId(actionId);
            agileReportKMData.setShow(show);
            agileReportKMData.setShowType(showType);
        }
        return agileReportKMData;
    }


}
