package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.show.domain.agileDataDTO.AgileReportDataFindDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportEChartDefineDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShow;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.CompletionEchartsDefine;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 柱状图解析
 */
@Slf4j
@Service()
public class CompletionBarDefineImpl extends CompletionEchartsDefine {
    @Override
    public String supportKey() {
        return "ECHARTS_DEFINE_3";
    }

    @Override
    protected List<AgileReportDataFindDTO> getXAxis(List<MetadataField> xAxisMetadataFields,Integer dimensionRelationShip) {
        List<AgileReportDataFindDTO> xAxisArray = Lists.newArrayList();
        AgileReportDataFindDTO xAxis = new AgileReportDataFindDTO();
        //主维度
        MetadataField mainDimension = null;

        //当出现1对1的分布情况，使用主维度作为x轴
        if(dimensionRelationShip != null && dimensionRelationShip == 0) {
            mainDimension = xAxisMetadataFields.stream().filter(metadataField -> metadataField.getIsMainDimension() != null &&
                    metadataField.getIsMainDimension()).findFirst().orElse(null);
        }
        if(mainDimension == null){
            mainDimension = xAxisMetadataFields.get(0);
        }
        xAxis.setApplyToField(mainDimension.getName());
        xAxis.setTitle(mainDimension.getDescription());
        xAxisArray.add(xAxis);
        return xAxisArray;
    }

    @Override
    protected void getEcharts(List<MetadataField> yAxisMetadataFields,AgileReportRuleDTO agileReportRuleDTO,
                              ApiMetadata apiMetadata,AgileReportShow showInfo, List<AgileReportDataFindDTO> xAxis,
                              List<AgileReportEChartDefineDTO> eChartDefineDTOList) {
        AgileReportEChartDefineDTO eChart = new AgileReportEChartDefineDTO();
        eChart.setXAxis(xAxis);
        List<AgileReportDataFindDTO> series = Lists.newArrayList();
        yAxisMetadataFields.stream().forEach(serieMetadataField -> {
            AgileReportDataFindDTO seriesDTO = new AgileReportDataFindDTO();
            seriesDTO.setApplyToField(serieMetadataField.getName());
            series.add(seriesDTO);
        });
        eChart.setSeries(series);
        eChartDefineDTOList.add(eChart);
    }
}
