package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.show.domain.agileDataDTO.AgileReportDataFindDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportEChartDefineDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShow;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.CompletionEchartsDefine;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

@Slf4j
@Service()
public class CompletionEchartsSceneDefineImpl extends CompletionEchartsDefine {
    @Override
    public String supportKey() {
        return "ECHARTS_DEFINE_1";
    }

    @Override
    protected List<AgileReportDataFindDTO> getXAxis(List<MetadataField> xAxisMetadataFields, Integer dimensionRelationShip) {
        List<AgileReportDataFindDTO> xAxisArray = Lists.newArrayList();
        AgileReportDataFindDTO xAxis = new AgileReportDataFindDTO();
        MetadataField metadataField = xAxisMetadataFields.get(0);
        xAxis.setApplyToField(metadataField.getName());
        xAxis.setTitle(metadataField.getDescription());
        xAxisArray.add(xAxis);
        return xAxisArray;
    }

    @Override
    protected void getEcharts(List<MetadataField> yAxisMetadataFields, AgileReportRuleDTO agileReportRuleDTO, ApiMetadata apiMetadata, AgileReportShow showInfo, List<AgileReportDataFindDTO> xAxis, List<AgileReportEChartDefineDTO> eChartDefineDTOList) {
        AgileReportEChartDefineDTO eChart = new AgileReportEChartDefineDTO();
        eChart.setXAxis(xAxis);
        List<AgileReportDataFindDTO> series = Lists.newArrayList();
        yAxisMetadataFields.stream().forEach(serieMetadataField -> {
            AgileReportDataFindDTO seriesDTO = new AgileReportDataFindDTO();
            seriesDTO.setApplyToField(serieMetadataField.getName());
            series.add(seriesDTO);
        });
        eChart.setSeries(series);
        eChartDefineDTOList.add(eChart);
    }
}
