package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.show.domain.agileDataDTO.*;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.CompletionEchartsDefine;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;
import java.util.Map;

/**
 * 双Y轴图解析
 */
@Slf4j
@Service()
public class CompletionMixDefineImpl extends CompletionEchartsDefine {
    @Override
    public String supportKey() {
        return "ECHARTS_DEFINE_4";
    }

    @Override
    protected List<AgileReportDataFindDTO> getXAxis(List<MetadataField> xAxisMetadataFields, Integer dimensionRelationShip) {
        List<AgileReportDataFindDTO> xAxisArray = Lists.newArrayList();
        AgileReportDataFindDTO xAxis = new AgileReportDataFindDTO();
        //主维度
        MetadataField mainDimension = null;

        //当出现1对1的分布情况，使用主维度作为x轴
        if(dimensionRelationShip != null && dimensionRelationShip == 0) {
            mainDimension = xAxisMetadataFields.stream().filter(metadataField -> metadataField.getIsMainDimension() != null &&
                    metadataField.getIsMainDimension()).findFirst().orElse(null);
        }
        if(mainDimension == null){
            mainDimension = xAxisMetadataFields.get(0);
        }
        xAxis.setApplyToField(mainDimension.getName());
        xAxis.setTitle(mainDimension.getDescription());
        xAxisArray.add(xAxis);
        return xAxisArray;
    }

    @Override
    protected void getEcharts(List<MetadataField> yAxisMetadataFields,AgileReportRuleDTO agileReportRuleDTO,
                         ApiMetadata apiMetadata,AgileReportShow showInfo, List<AgileReportDataFindDTO> xAxis,
                         List<AgileReportEChartDefineDTO> eChartDefineDTOList) {
        ApiMetadata masterMetadata = ConvertGetAgileData.getMasterMetadata(showInfo.getTargetSource(), apiMetadata);
        Map<String, MetadataField> filedMap = ConvertGetAgileData.getFiledMap(showInfo.getTargetSource(), masterMetadata);
        //按展示顺序排序
        agileReportRuleDTO.getRules().sort(Comparator.comparing(direction -> "left".equals(direction.getDirection()) ? 0 : 1));
        //按规则进行双轴分组
        agileReportRuleDTO.getRules().stream().forEach(rule -> rule.getAreaDefine().stream().forEach(area -> {
            List<AgileReportDataFindDTO> series = Lists.newArrayList();
            AgileReportEChartDefineDTO eChart = new AgileReportEChartDefineDTO();
            eChart.setXAxis(xAxis);
            //绑定度量字段
            area.getApplyToFields().stream().forEach(areaField -> {
                MetadataField field = filedMap.get(areaField);
                if (field == null) {
                    return;
                }
                AgileReportDataFindDTO seriesDTO = new AgileReportDataFindDTO();
                seriesDTO.setApplyToField(field.getName());
                seriesDTO.setTitle(field.getDescription());
                seriesDTO.setChart(area.getChart());
                series.add(seriesDTO);
            });
            eChart.setSeries(series);
            eChartDefineDTOList.add(eChart);
        }));
    }
}
