package com.digiwin.athena.show.service.ppt;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.show.domain.ppt.AgileDataFileDTO;
import com.digiwin.athena.show.domain.ppt.AgileDataFileQueryReq;

public interface AgileDataFileManagerService {

    /**
     * 获取分析规划信息
     * @param agileDataFileQueryReq
     * @return
     */
    AgileDataFileDTO queryAgileDataFile(AuthoredUser user,AgileDataFileQueryReq agileDataFileQueryReq);

    /**
     * 保存分析规划信息
     * @param user
     * @param agileDataFileDTO
     * @return
     */
    Boolean saveAgileDataFile(AuthoredUser user,AgileDataFileDTO agileDataFileDTO);

    /**
     * 更新分析规划信息
     * @param user
     * @param agileDataFileDTO
     * @return
     */
    Boolean updateAgileDataFile(AuthoredUser user,AgileDataFileDTO agileDataFileDTO);

    /**
     * 删除分析规划信息
     * @param user
     * @param agileDataFileQueryReq
     * @return
     */
    Boolean deleteAgileDataFile(AuthoredUser user,AgileDataFileQueryReq agileDataFileQueryReq);

}
