package com.digiwin.athena.show.util;

import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @description: 自动生成
 * @author: wangminga
 * @create: 2020-06-29 14:21
 **/
public class ApiMetadataUtil {

    /**
     * 获取路劲名称
     *
     * @param parentPathName
     * @param metadataField
     * @return
     */
    public static String pathFieldName(String parentPathName, MetadataField metadataField) {
        String pathFieldName;
        if (StringUtils.isBlank(parentPathName)) {
            pathFieldName = metadataField.getName();
        } else {
            pathFieldName = parentPathName + "." + metadataField.getName();
        }
        return pathFieldName;
    }


    public static void flatMetaData(ApiMetadata apiMetadata) {
        if (apiMetadata == null) {
            return;
        }
        if (CollectionUtils.isEmpty(apiMetadata.getResponseFields())) {
            return;
        }
        Map<String, MetadataField> fieldMap = new LinkedHashMap<>();
        apiMetadata.setResponseFieldMap(fieldMap);
        for (MetadataField rootField : apiMetadata.getResponseFields()) {
            fieldMap.put(rootField.getName(), rootField);
            rootField.setPath(null);
            rootField.flatMetaData(null);
        }
        fieldMap = new LinkedHashMap<>();
        apiMetadata.setRequestFieldMap(fieldMap);
        if (apiMetadata.getRequestFields() != null) {
            for (MetadataField rootField : apiMetadata.getRequestFields()) {
                fieldMap.put(rootField.getName(), rootField);
                rootField.setPath(null);
                rootField.flatMetaData(null);
            }
        }
    }

    public static void flatMetaDataNotFlatPath(ApiMetadata apiMetadata) {
        if (CollectionUtils.isEmpty(apiMetadata.getResponseFields())) {
            return;
        }
        Map<String, MetadataField> fieldMap = new HashMap<>();
        apiMetadata.setResponseFieldMap(fieldMap);
        for (MetadataField rootField : apiMetadata.getResponseFields()) {
            fieldMap.put(rootField.getName(), rootField);
            rootField.setPath(rootField.getPath());
            rootField.flatMetaDataNotFlatPath(null);
        }
        fieldMap = new HashMap<>();
        apiMetadata.setRequestFieldMap(fieldMap);
        if (apiMetadata.getRequestFields() != null) {
            for (MetadataField rootField : apiMetadata.getRequestFields()) {
                fieldMap.put(rootField.getName(), rootField);
                rootField.setPath(rootField.getPath());
                rootField.flatMetaDataNotFlatPath(null);
            }
        }
    }

    public static List<String> getDataKeys(List<MetadataField> metadataFields) {
        if (CollectionUtils.isEmpty(metadataFields)) {
            return Collections.emptyList();
        }

        List<String> dataKeys = metadataFields.stream()
                .filter(metadataFieldDTO -> metadataFieldDTO.isBusinessKey())
                .map(metadataFieldDTO -> metadataFieldDTO.getName())
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dataKeys)) {
            dataKeys = metadataFields.stream()
                    .filter(metadataFieldDTO -> "true".equals(metadataFieldDTO.getDataKey()))
                    .map(metadataFieldDTO -> metadataFieldDTO.getName())
                    .collect(Collectors.toList());
        }
        return dataKeys;
    }


    /**
     * 根据字段名称，获取其对应的元数据
     *
     * @param metadataName
     * @param apiMetadata
     * @return
     */
    public static ApiMetadata getApiMetadataByMetaName(String metadataName, ApiMetadata apiMetadata) {
        if (CollectionUtils.isEmpty(apiMetadata.getResponseFields())) {
            return apiMetadata;
        }
        ApiMetadata subApiMetadata = new ApiMetadata();
        subApiMetadata.setServiceName(apiMetadata.getServiceName());
        subApiMetadata.setActionId(apiMetadata.getActionId());
        MetadataField metadataField = apiMetadata.getResponseFields().get(0);
        if ("object".equals(metadataField.getDataType()) && metadataName.equals(metadataField.getName())) {
            subApiMetadata.setResponseFields(apiMetadata.getResponseFields());
            subApiMetadata.setResponseFieldMap(apiMetadata.getResponseFieldMap());
            return subApiMetadata;
        }
        if (CollectionUtils.isNotEmpty(metadataField.getSubFields())) {
            for (MetadataField subMetadataField : metadataField.getSubFields()) {
                if ("object".equals(subMetadataField.getDataType()) && metadataName.equals(subMetadataField.getName())) {
                    subMetadataField.setPath(null);
                    subApiMetadata.setResponseFields(Collections.singletonList(subMetadataField));
                    Map<String, MetadataField> responseFieldMap = new HashMap<>();
                    responseFieldMap.put(metadataName, metadataField.getFieldMap().get(metadataName));
                    subApiMetadata.setResponseFieldMap(responseFieldMap);
                    break;
                }
                if (CollectionUtils.isEmpty(subApiMetadata.getResponseFields())) {
                    getsubApiMetadata(metadataName, subApiMetadata, subMetadataField);
                }
            }
        }
        return subApiMetadata;
    }

    private static void getsubApiMetadata(String metadataName, ApiMetadata subApiMetadata, MetadataField metadataField) {
        if (CollectionUtils.isNotEmpty(metadataField.getSubFields())) {
            for (MetadataField subMetadataField : metadataField.getSubFields()) {
                if ("object".equals(subMetadataField.getDataType()) && metadataName.equals(subMetadataField.getName())) {
                    subApiMetadata.setResponseFields(subMetadataField.getSubFields());
                    subApiMetadata.setResponseFieldMap(subMetadataField.getFieldMap());
                    break;
                }
            }
        }
    }




    /**
     *  根据path取不重复单身值
     * @param row 当前行数据
     * @param list 单身值
     * @param paths 路径
     * @param level 当前等级
     */
    public static void addDepData(Map<String, Object> row, LinkedHashSet<Object> list, String[] paths, int level){
        Object o = row.get(paths[level]);
        if(level >= (paths.length-1)){
            if(o != null){
                list.add(o);
            }
        }else {
            int nextLevel = level+1;
            if(o instanceof Map){
                addDepData((Map<String, Object>) o,list,paths,nextLevel);
            }else if(o instanceof List){
                List<Map<String,Object>> dRows = (List<Map<String, Object>>) o;
                if(CollectionUtils.isNotEmpty(dRows)){
                    for (Map<String, Object> dRow : dRows) {
                        addDepData(dRow,list,paths,nextLevel);
                    }
                }
            }
        }
    }

}
