package com.digiwin.athena.show.util.layout;

import com.digiwin.athena.show.component.echarts.EchartsComponent;
import com.digiwin.athena.show.component.grid.GridComponent;
import com.digiwin.athena.show.component.index.AgileDataIndexComponent;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.infrastructure.meta.ECHOConstants;
import com.digiwin.athena.show.metadata.MetadataField;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * 构建
 */
public class AgileDataBoardComponentBuild {

    public static AgileDataIndexComponent buildBoardIndex(String id,MetadataField metadataField){
        AgileDataIndexComponent agileDataIndexComponent = new AgileDataIndexComponent();
        agileDataIndexComponent.setType(ECHOConstants.ComponentType.STATISTIC);
        List<MetadataField> fields = getMeasurementField(metadataField);
        if(CollectionUtils.isNotEmpty(fields)){
            List<AgileDataIndexComponent.AgileDataIndex> group = Lists.newArrayList();
            fields.stream().forEach(field -> group.add(new AgileDataIndexComponent.AgileDataIndex()));
            agileDataIndexComponent.setGroup(group);
        }
        agileDataIndexComponent.setId(id);
        return agileDataIndexComponent;
    }

    public static EchartsComponent buildBoardEcharts(String id){
        EchartsComponent echartsComponent = new EchartsComponent();
        echartsComponent.setType(ECHOConstants.ComponentType.ECHARTS);
        echartsComponent.setId(id);
        return echartsComponent;
    }

    public static GridComponent buildBoardGrid(String id){
        GridComponent gridComponent = new GridComponent();
        gridComponent.setType(ECHOConstants.ComponentType.ATHENA_TABLE);
        gridComponent.setId(id);
        return gridComponent;
    }

    public static List<MetadataField> getMeasurementField(MetadataField metadataField){
        List<MetadataField> fields = Lists.newArrayList();
        if (metadataField.isObjectField()) {
            metadataField.getSubFields().stream().forEach(field -> fields.addAll(getMeasurementField(field)) );
        } else {
            fields.add(metadataField);
        }
        return fields;
    }


}
