package com.digiwin.athena.show.util.layout;

import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 敏数数据校验
 */
public class AgileDataCheck {

    /**
     * 大屏基础数据校验
     * @param agileReportDTO
     * @return
     */
    public static Boolean screenBasicCheck(SnapDataDTO agileReportDTO){
        if (agileReportDTO == null || agileReportDTO.getSnapData() == null || MapUtils.isEmpty(agileReportDTO.getPageData())) {
            return true;
        }
        return false;
    }

    /**
     * 场景基础数据校验
     * @param agileReportDTO
     * @return
     */
    public static Boolean sceneBasicCheck(SnapDataDTO agileReportDTO){
        //无基础信息
        if (agileReportDTO == null || MapUtils.isEmpty(agileReportDTO.getPageData()) || agileReportDTO.getSnapData() == null) {
            return true;
        }
        //无数据信息
        Iterator<Map.Entry<String, Object>> iterator = agileReportDTO.getPageData().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if(entry.getValue() instanceof List){
                List<Map<String,Object>> dataList = (List<Map<String, Object>>) entry.getValue();
                dataList.removeIf(data -> !data.containsKey("data") || data.get("data") == null);
                if(CollectionUtils.isEmpty(dataList)){
                    iterator.remove();
                }
            }
        }
        if(MapUtils.isEmpty(agileReportDTO.getPageData())){
            return true;
        }
        return false;
    }


    /**
     * 是否为大屏入口
     * @param executeContext
     * @return
     */
    public static Boolean isScreen(ExecuteContext executeContext){
        Map<String,Object> agileData = executeContext.getAgileData();
        String entry = MapUtils.getString(agileData,"entry");
        if(StringUtils.isNotEmpty(entry)){
            return "1".equals(entry);
        }
        return false;
    }


}
